/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import org.apache.nifi.properties.BootstrapProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBootstrapPropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBootstrapPropertiesLoader.class);
    private static final String RELATIVE_APPLICATION_PROPERTIES_PATTERN = "conf/%s";
    private static final String BOOTSTRAP_CONF = "bootstrap.conf";

    protected abstract String getApplicationPrefix();

    protected abstract String getApplicationPropertiesFilename();

    protected abstract String getApplicationPropertiesFilePathSystemProperty();

    public BootstrapProperties loadBootstrapProperties(String bootstrapPath) throws IOException {
        Path bootstrapFilePath = this.getBootstrapFile(bootstrapPath).toPath();
        return AbstractBootstrapPropertiesLoader.loadBootstrapProperties(bootstrapFilePath, this.getApplicationPrefix());
    }

    public static BootstrapProperties loadBootstrapProperties(Path bootstrapPath, String propertyPrefix) throws IOException {
        BootstrapProperties bootstrapProperties;
        block8: {
            Objects.requireNonNull(bootstrapPath, "Bootstrap path must be provided");
            Objects.requireNonNull(propertyPrefix, "Property prefix must be provided");
            Properties properties = new Properties();
            InputStream bootstrapInput = Files.newInputStream(bootstrapPath, new OpenOption[0]);
            try {
                properties.load(bootstrapInput);
                bootstrapProperties = new BootstrapProperties(propertyPrefix, properties, bootstrapPath);
                if (bootstrapInput == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bootstrapInput != null) {
                        try {
                            bootstrapInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Cannot read from " + String.valueOf(bootstrapPath), e);
                }
            }
            bootstrapInput.close();
        }
        return bootstrapProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getBootstrapFile(String bootstrapPath) throws IOException {
        File expectedBootstrapFile;
        if (bootstrapPath == null) {
            String defaultApplicationPropertiesFilePath = this.getDefaultApplicationPropertiesFilePath();
            File propertiesFile = new File(defaultApplicationPropertiesFilePath);
            File confDir = new File(propertiesFile.getParent());
            if (!confDir.exists() || !confDir.canRead()) throw new IOException(String.format("Configuration Directory [%s] not found for Bootstrap Properties", confDir));
            expectedBootstrapFile = new File(confDir, BOOTSTRAP_CONF);
        } else {
            expectedBootstrapFile = new File(bootstrapPath);
        }
        if (!expectedBootstrapFile.exists() || !expectedBootstrapFile.canRead()) throw new IOException("Cannot read from " + expectedBootstrapFile.getAbsolutePath());
        return expectedBootstrapFile;
    }

    public String getDefaultApplicationPropertiesFilePath() {
        String systemPropertyName = this.getApplicationPropertiesFilePathSystemProperty();
        String defaultRelativePath = String.format(RELATIVE_APPLICATION_PROPERTIES_PATTERN, this.getApplicationPropertiesFilename());
        String systemPath = System.getProperty(systemPropertyName);
        if (systemPath == null || systemPath.trim().isEmpty()) {
            logger.warn("System Property [{}] not found: Using Relative Path [{}]", (Object)systemPropertyName, (Object)defaultRelativePath);
            System.setProperty(systemPropertyName, defaultRelativePath);
            systemPath = defaultRelativePath;
        }
        logger.debug("Default Application Properties Path [{}]", (Object)systemPath);
        return systemPath;
    }
}

