/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.config.transformer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.properties.scheme.ProtectionScheme;
import org.apache.nifi.toolkit.config.transformer.FileTransformer;
import org.apache.nifi.xml.processing.stream.StandardXMLEventReaderProvider;
import org.apache.nifi.xml.processing.stream.XMLEventReaderProvider;

public class XmlFileTransformer
implements FileTransformer {
    private static final Pattern SENSITIVE_PATTERN = Pattern.compile("Password|Secret");
    private static final QName NAME_ATTRIBUTE = QName.valueOf("name");
    private static final QName ENCRYPTION_ATTRIBUTE = QName.valueOf("encryption");
    private static final String IDENTIFIER_ELEMENT_NAME = "identifier";
    private static final XMLEventReaderProvider readerProvider = new StandardXMLEventReaderProvider();
    private final XMLEventFactory eventFactory = XMLEventFactory.newFactory();
    private final SensitivePropertyProvider inputSensitivePropertyProvider;
    private final SensitivePropertyProviderFactory sensitivePropertyProviderFactory;
    private final SensitivePropertyProvider sensitivePropertyProvider;

    public XmlFileTransformer(SensitivePropertyProvider inputSensitivePropertyProvider, SensitivePropertyProviderFactory sensitivePropertyProviderFactory, ProtectionScheme protectionScheme) {
        this.inputSensitivePropertyProvider = Objects.requireNonNull(inputSensitivePropertyProvider, "Input Sensitive Property Provider required");
        this.sensitivePropertyProviderFactory = Objects.requireNonNull(sensitivePropertyProviderFactory, "Sensitive Property Provider Factory required");
        this.sensitivePropertyProvider = sensitivePropertyProviderFactory.getProvider(Objects.requireNonNull(protectionScheme, "Protection Scheme required"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(Path inputPath, Path outputPath) throws IOException {
        Objects.requireNonNull(inputPath, "Input path required");
        Objects.requireNonNull(outputPath, "Output path required");
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
             OutputStream outputStream = Files.newOutputStream(outputPath, new OpenOption[0]);){
            StreamSource streamSource = new StreamSource(inputStream);
            XMLEventReader eventReader = readerProvider.getEventReader(streamSource);
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(outputStream);
            try {
                this.transform(eventReader, eventWriter);
            }
            finally {
                eventReader.close();
                eventWriter.close();
            }
        }
        catch (XMLStreamException e) {
            String message = String.format("XML processing failed [%s]", inputPath);
            throw new IOException(message, e);
        }
    }

    protected void transform(XMLEventReader eventReader, XMLEventWriter eventWriter) throws XMLStreamException {
        String groupIdentifier = null;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                QName startElementName = startElement.getName();
                String startElementLocalPart = startElementName.getLocalPart();
                if (IDENTIFIER_ELEMENT_NAME.equals(startElementLocalPart)) {
                    XMLEvent nextEvent = eventReader.nextEvent();
                    if (nextEvent.isCharacters()) {
                        groupIdentifier = nextEvent.asCharacters().getData();
                    }
                    eventWriter.add(startElement);
                    eventWriter.add(nextEvent);
                    continue;
                }
                if (this.isEncryptionRequired(startElement)) {
                    this.transformStartElement(eventReader, eventWriter, startElement, groupIdentifier);
                    continue;
                }
                eventWriter.add(event);
                continue;
            }
            eventWriter.add(event);
        }
    }

    private boolean isEncryptionSupported(String propertyName) {
        boolean encryptionSupported = propertyName == null || propertyName.isEmpty() ? false : SENSITIVE_PATTERN.matcher(propertyName).find();
        return encryptionSupported;
    }

    private boolean isEncryptionRequired(StartElement startElement) {
        String name = this.getNameAttribute(startElement);
        return this.isEncryptionSupported(name);
    }

    private void transformStartElement(XMLEventReader eventReader, XMLEventWriter eventWriter, StartElement startElement, String groupIdentifier) throws XMLStreamException {
        XMLEvent nextEvent = eventReader.nextEvent();
        if (nextEvent.isCharacters()) {
            Attribute nameAttribute = startElement.getAttributeByName(NAME_ATTRIBUTE);
            String propertyName = nameAttribute.getValue();
            ProtectedPropertyContext propertyContext = this.sensitivePropertyProviderFactory.getPropertyContext(groupIdentifier, propertyName);
            StartElement encryptedStartElement = this.getEncryptedStartElement(startElement);
            eventWriter.add(encryptedStartElement);
            String data = nextEvent.asCharacters().getData();
            String encryption = this.getEncryptionAttribute(startElement);
            String inputData = encryption == null ? data : this.inputSensitivePropertyProvider.unprotect(data, propertyContext);
            String protectedProperty = this.sensitivePropertyProvider.protect(inputData, propertyContext);
            Characters characters = this.eventFactory.createCharacters(protectedProperty);
            eventWriter.add(characters);
        } else {
            eventWriter.add(startElement);
            eventWriter.add(nextEvent);
        }
    }

    private String getNameAttribute(StartElement startElement) {
        Attribute attribute = startElement.getAttributeByName(NAME_ATTRIBUTE);
        return attribute == null ? null : attribute.getValue();
    }

    private String getEncryptionAttribute(StartElement startElement) {
        Attribute attribute = startElement.getAttributeByName(ENCRYPTION_ATTRIBUTE);
        return attribute == null ? null : attribute.getValue();
    }

    private StartElement getEncryptedStartElement(StartElement startElement) {
        String name = this.getNameAttribute(startElement);
        Attribute nameAttribute = this.eventFactory.createAttribute(NAME_ATTRIBUTE, name);
        Attribute encryptionAttribute = this.eventFactory.createAttribute(ENCRYPTION_ATTRIBUTE, this.sensitivePropertyProvider.getIdentifierKey());
        Iterator<Attribute> attributes = Arrays.asList(encryptionAttribute, nameAttribute).iterator();
        Iterator<Namespace> namespaces = startElement.getNamespaces();
        return this.eventFactory.createStartElement(startElement.getName(), attributes, namespaces);
    }
}

