/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.config.transformer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.encryptor.JsonFlowEncryptor;
import org.apache.nifi.toolkit.config.transformer.FileTransformer;

public class FlowConfigurationFileTransformer
implements FileTransformer {
    private final PropertyEncryptor inputEncryptor;
    private final PropertyEncryptor outputEncryptor;

    public FlowConfigurationFileTransformer(PropertyEncryptor inputEncryptor, PropertyEncryptor outputEncryptor) {
        this.inputEncryptor = Objects.requireNonNull(inputEncryptor, "Input Encryptor required");
        this.outputEncryptor = Objects.requireNonNull(outputEncryptor, "Output Encryptor required");
    }

    @Override
    public void transform(Path inputPath, Path outputPath) throws IOException {
        Objects.requireNonNull(inputPath, "Input path required");
        Objects.requireNonNull(outputPath, "Output path required");
        try (GZIPInputStream inputStream = new GZIPInputStream(Files.newInputStream(inputPath, new OpenOption[0]));
             GZIPOutputStream outputStream = new GZIPOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            JsonFlowEncryptor flowEncryptor = new JsonFlowEncryptor();
            flowEncryptor.processFlow((InputStream)inputStream, (OutputStream)outputStream, this.inputEncryptor, this.outputEncryptor);
        }
    }
}

