/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.config.transformer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.properties.ApplicationProperties;
import org.apache.nifi.properties.ApplicationPropertiesProtector;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.toolkit.config.transformer.FileTransformer;

public class ApplicationPropertiesFileTransformer
implements FileTransformer {
    private static final Pattern PROPERTY_VALUE_PATTERN = Pattern.compile("^([^#!][^=]+?)\\s*=\\s?(.+)");
    private static final int NAME_GROUP = 1;
    private static final int VALUE_GROUP = 2;
    private static final char PROPERTY_VALUE_SEPARATOR = '=';
    private final ApplicationProperties applicationProperties;
    private final SensitivePropertyProvider outputSensitivePropertyProvider;
    private final Set<String> sensitivePropertyNames;

    public ApplicationPropertiesFileTransformer(ApplicationProperties applicationProperties, SensitivePropertyProvider outputSensitivePropertyProvider, Set<String> sensitivePropertyNames) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties, "Application Properties required");
        this.outputSensitivePropertyProvider = Objects.requireNonNull(outputSensitivePropertyProvider, "Output Property Provider required");
        this.sensitivePropertyNames = Objects.requireNonNull(sensitivePropertyNames, "Sensitive Property Names required");
    }

    @Override
    public void transform(Path inputPath, Path outputPath) throws IOException {
        Objects.requireNonNull(inputPath, "Input path required");
        Objects.requireNonNull(outputPath, "Output path required");
        try (BufferedReader reader = Files.newBufferedReader(inputPath);
             BufferedWriter writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
            this.transform(reader, writer);
        }
    }

    private void transform(BufferedReader reader, BufferedWriter writer) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = PROPERTY_VALUE_PATTERN.matcher(line);
            if (matcher.matches()) {
                String name = matcher.group(1);
                String value = matcher.group(2);
                String protectedName = ApplicationPropertiesProtector.getProtectionKey((String)name);
                String nextLine = reader.readLine();
                if (nextLine == null) {
                    if (this.sensitivePropertyNames.contains(name)) {
                        this.writeProtectedProperty(writer, name, value);
                        break;
                    }
                    writer.write(line);
                    writer.newLine();
                    break;
                }
                Matcher nextLineMatcher = PROPERTY_VALUE_PATTERN.matcher(nextLine);
                if (nextLineMatcher.matches()) {
                    String nextName = nextLineMatcher.group(1);
                    String nextValue = nextLineMatcher.group(2);
                    if (protectedName.equals(nextName)) {
                        String applicationProperty = this.applicationProperties.getProperty(name, value);
                        this.writeProtectedProperty(writer, name, applicationProperty);
                    } else {
                        if (this.sensitivePropertyNames.contains(name)) {
                            this.writeProtectedProperty(writer, name, value);
                        } else {
                            writer.write(line);
                            writer.newLine();
                        }
                        if (this.sensitivePropertyNames.contains(nextName)) {
                            this.writeProtectedProperty(writer, nextName, nextValue);
                        } else {
                            writer.write(nextLine);
                            writer.newLine();
                        }
                    }
                } else if (this.sensitivePropertyNames.contains(name)) {
                    this.writeProtectedProperty(writer, name, value);
                } else {
                    writer.write(line);
                    writer.newLine();
                    writer.write(nextLine);
                    writer.newLine();
                }
            } else {
                writer.write(line);
                writer.newLine();
            }
            line = reader.readLine();
        }
    }

    private void writeProtectedProperty(BufferedWriter writer, String name, String value) throws IOException {
        ProtectedPropertyContext propertyContext = ProtectedPropertyContext.defaultContext((String)name);
        String protectedValue = this.outputSensitivePropertyProvider.protect(value, propertyContext);
        writer.write(name);
        writer.write(61);
        writer.write(protectedValue);
        writer.newLine();
        String protectedName = ApplicationPropertiesProtector.getProtectionKey((String)name);
        writer.write(protectedName);
        writer.write(61);
        String protectionIdentifierKey = this.outputSensitivePropertyProvider.getIdentifierKey();
        writer.write(protectionIdentifierKey);
        writer.newLine();
    }
}

