/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.config.command;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptorBuilder;
import org.apache.nifi.properties.ApplicationProperties;
import org.apache.nifi.properties.ApplicationPropertiesProtector;
import org.apache.nifi.properties.NiFiPropertiesLoader;
import org.apache.nifi.properties.ProtectedNiFiProperties;
import org.apache.nifi.properties.ProtectedProperties;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.toolkit.config.command.SharedEncryptConfig;
import org.apache.nifi.toolkit.config.transformer.ApplicationPropertiesFileTransformer;
import org.apache.nifi.toolkit.config.transformer.FlowConfigurationFileTransformer;
import org.apache.nifi.toolkit.config.transformer.XmlFileTransformer;
import picocli.CommandLine;

@CommandLine.Command
public class StandardEncryptConfig
extends SharedEncryptConfig
implements Runnable {
    static final String BOOTSTRAP_ROOT_KEY_PROPERTY = "nifi.bootstrap.sensitive.key";
    private static final String DEFAULT_PROPERTIES_ALGORITHM = "NIFI_PBKDF2_AES_GCM_256";
    @CommandLine.Option(names={"-m", "--migrate"}, description={"Migrate configuration files from current protection configuration to new protection configuration"})
    boolean migrationRequested;
    @CommandLine.Option(names={"-x", "--encryptFlowXmlOnly", "--encryptFlowJsonOnly"}, description={"Process Flow Configuration [flow.json.gz] sensitive property values without modifying other configuration files"})
    boolean flowConfigurationRequested;
    @CommandLine.Option(names={"-n", "--niFiProperties"}, description={"Path to file containing Application Properties [nifi.properties] that will be updated unless the output argument is provided"})
    Path applicationPropertiesPath;
    @CommandLine.Option(names={"-o", "--outputNiFiProperties"}, description={"Path to output file for Application Properties [nifi.properties] with property protection applied"})
    Path outputApplicationPropertiesPath;
    @CommandLine.Option(names={"-l", "--loginIdentityProviders"}, description={"Path to file containing Login Identity Providers [login-identity-providers.xml] configuration that will be updated unless the output argument is provided"})
    Path loginIdentityProvidersPath;
    @CommandLine.Option(names={"-i", "--outputLoginIdentityProviders"}, description={"Path to output file for Login Identity Providers [login-identity-providers.xml] with property protection applied"})
    Path outputLoginIdentityProvidersPath;
    @CommandLine.Option(names={"-f", "--flowConfiguration", "--flowJson", "--flowXml"}, description={"Path to file containing Flow Configuration [flow.json.gz] that will be updated unless the output argument is provided"})
    Path flowConfigurationPath;
    @CommandLine.Option(names={"-g", "--outputFlowConfiguration", "--outputFlowJson", "--outputFlowXml"}, description={"Path to output file for Flow Configuration [flow.json.gz] with property protection applied"})
    Path outputFlowConfigurationPath;
    @CommandLine.Option(names={"-s", "--propsKey"}, description={"Properties Key [nifi.sensitive.props.key] from which to derive the key used to encrypt the sensitive values in the Flow Configuration"}, arity="0..1", interactive=true)
    String sensitivePropertiesKey;
    @CommandLine.Option(names={"-A", "--newFlowAlgorithm"}, description={"Properties Algorithm [nifi.sensitive.props.algorithm] with which to encrypt the sensitive values in the Flow Configuration. Default is ${DEFAULT-VALUE}"}, defaultValue="NIFI_PBKDF2_AES_GCM_256")
    String newFlowAlgorithm;

    @Override
    public void run() {
        ApplicationProperties applicationProperties = this.loadApplicationProperties();
        this.processBootstrapConf(BOOTSTRAP_ROOT_KEY_PROPERTY);
        this.processApplicationProperties(applicationProperties);
        this.processFlowConfiguration(applicationProperties);
        this.processAuthorizers();
        this.processLoginIdentityProviders();
    }

    @Override
    protected void processBootstrapConf(String rootKeyProperty) {
        if (this.flowConfigurationRequested) {
            this.logger.info("Bootstrap Configuration [bootstrap.conf] not modified based on provided arguments");
        } else {
            super.processBootstrapConf(rootKeyProperty);
        }
    }

    @Override
    protected void processAuthorizers() {
        if (this.flowConfigurationRequested) {
            this.logger.info("Authorizers not modified based on provided arguments");
        } else {
            super.processAuthorizers();
        }
    }

    private ApplicationProperties loadApplicationProperties() {
        ApplicationProperties applicationProperties;
        if (this.applicationPropertiesPath == null) {
            applicationProperties = new ApplicationProperties(Collections.emptyMap());
            if (this.verboseModeEnabled) {
                this.logger.info("Application Properties [nifi.properties] not specified");
            }
        } else {
            if (Files.notExists(this.applicationPropertiesPath, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("Application Properties [nifi.properties] not found [%s]", this.applicationPropertiesPath));
            }
            NiFiPropertiesLoader propertiesLoader = new NiFiPropertiesLoader();
            String rootKey = this.migrationRequested ? this.getInputRootKey() : this.getRootKey();
            propertiesLoader.setKeyHex(rootKey);
            applicationProperties = propertiesLoader.load(this.applicationPropertiesPath.toFile());
        }
        return applicationProperties;
    }

    private void processApplicationProperties(ApplicationProperties applicationProperties) {
        if (this.applicationPropertiesPath == null) {
            if (this.verboseModeEnabled) {
                this.logger.info("Application Properties [nifi.properties] not specified");
            }
        } else if (this.flowConfigurationRequested) {
            this.logger.info("Application Properties [nifi.properties] not modified based on provided arguments");
        } else {
            this.logger.info("Started processing Application Properties [{}]", (Object)this.applicationPropertiesPath);
            SensitivePropertyProviderFactory sensitivePropertyProviderFactory = this.getSensitivePropertyProviderFactory();
            SensitivePropertyProvider sensitivePropertyProvider = sensitivePropertyProviderFactory.getProvider(this.protectionScheme);
            Set<String> sensitivePropertyNames = this.getSensitivePropertyNames();
            ApplicationPropertiesFileTransformer fileTransformer = new ApplicationPropertiesFileTransformer(applicationProperties, sensitivePropertyProvider, sensitivePropertyNames);
            this.runFileTransformer(fileTransformer, this.applicationPropertiesPath, this.outputApplicationPropertiesPath);
            this.logger.info("Completed processing Application Properties [{}]", (Object)this.applicationPropertiesPath);
        }
    }

    private void processFlowConfiguration(ApplicationProperties applicationProperties) {
        if (this.flowConfigurationPath == null) {
            if (this.verboseModeEnabled) {
                this.logger.info("Flow Configuration not specified");
            }
        } else {
            this.logger.info("Started processing Flow Configuration [{}]", (Object)this.flowConfigurationPath);
            PropertyEncryptor inputPropertyEncryptor = this.getInputPropertyEncryptor(applicationProperties);
            PropertyEncryptor outputPropertyEncryptor = this.getOutputPropertyEncryptor(applicationProperties);
            FlowConfigurationFileTransformer fileTransformer = new FlowConfigurationFileTransformer(inputPropertyEncryptor, outputPropertyEncryptor);
            this.runFileTransformer(fileTransformer, this.flowConfigurationPath, this.outputFlowConfigurationPath);
            this.logger.info("Completed processing Flow Configuration [{}]", (Object)this.flowConfigurationPath);
        }
    }

    private void processLoginIdentityProviders() {
        if (this.loginIdentityProvidersPath == null) {
            if (this.verboseModeEnabled) {
                this.logger.info("Login Identity Providers not specified");
            }
        } else if (this.flowConfigurationRequested) {
            this.logger.info("Login Identity Providers not modified based on provided arguments");
        } else {
            this.logger.info("Started processing Login Identity Providers [{}]", (Object)this.loginIdentityProvidersPath);
            SensitivePropertyProvider inputSensitivePropertyProvider = this.getInputSensitivePropertyProvider();
            SensitivePropertyProviderFactory sensitivePropertyProviderFactory = this.getSensitivePropertyProviderFactory();
            XmlFileTransformer fileTransformer = new XmlFileTransformer(inputSensitivePropertyProvider, sensitivePropertyProviderFactory, this.protectionScheme);
            this.runFileTransformer(fileTransformer, this.loginIdentityProvidersPath, this.outputLoginIdentityProvidersPath);
            this.logger.info("Completed processing Login Identity Providers [{}]", (Object)this.loginIdentityProvidersPath);
        }
    }

    private PropertyEncryptor getInputPropertyEncryptor(ApplicationProperties applicationProperties) {
        String applicationSensitivePropertiesKey = applicationProperties.getProperty("nifi.sensitive.props.key");
        if (applicationSensitivePropertiesKey == null) {
            throw new IllegalArgumentException(String.format("Sensitive Properties Key [%s] not found in Application Properties", "nifi.sensitive.props.key"));
        }
        String sensitivePropertiesAlgorithm = applicationProperties.getProperty("nifi.sensitive.props.algorithm", DEFAULT_PROPERTIES_ALGORITHM);
        return new PropertyEncryptorBuilder(applicationSensitivePropertiesKey).setAlgorithm(sensitivePropertiesAlgorithm).build();
    }

    private PropertyEncryptor getOutputPropertyEncryptor(ApplicationProperties applicationProperties) {
        if (this.sensitivePropertiesKey == null) {
            throw new IllegalArgumentException("Sensitive Properties Key not provided");
        }
        String sensitivePropertiesAlgorithm = applicationProperties.getProperty("nifi.sensitive.props.algorithm", DEFAULT_PROPERTIES_ALGORITHM);
        String outputPropertiesAlgorithm = Objects.requireNonNullElse(this.newFlowAlgorithm, sensitivePropertiesAlgorithm);
        if (this.verboseModeEnabled) {
            this.logger.info("Output Sensitive Properties Algorithm configured [{}]", (Object)outputPropertiesAlgorithm);
        }
        return new PropertyEncryptorBuilder(this.sensitivePropertiesKey).setAlgorithm(outputPropertiesAlgorithm).build();
    }

    private Set<String> getSensitivePropertyNames() {
        ApplicationPropertiesProtector protector = new ApplicationPropertiesProtector((ProtectedProperties)new ProtectedNiFiProperties());
        return Set.copyOf(protector.getSensitivePropertyKeys());
    }
}

