/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.config.command;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import org.apache.nifi.properties.ApplicationProperties;
import org.apache.nifi.properties.ApplicationPropertiesProtector;
import org.apache.nifi.properties.ProtectedProperties;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.registry.properties.NiFiRegistryPropertiesLoader;
import org.apache.nifi.registry.properties.ProtectedNiFiRegistryProperties;
import org.apache.nifi.toolkit.config.command.SharedEncryptConfig;
import org.apache.nifi.toolkit.config.transformer.ApplicationPropertiesFileTransformer;
import org.apache.nifi.toolkit.config.transformer.XmlFileTransformer;
import picocli.CommandLine;

@CommandLine.Command
public class RegistryEncryptConfig
extends SharedEncryptConfig
implements Runnable {
    static final String BOOTSTRAP_ROOT_KEY_PROPERTY = "nifi.registry.bootstrap.sensitive.key";
    @CommandLine.Option(names={"-r", "--nifiRegistryProperties"}, description={"Path to file containing Application Properties [nifi-registry.properties] that will be updated unless the output argument is provided"})
    Path applicationPropertiesPath;
    @CommandLine.Option(names={"-R", "--outputNiFiProperties"}, description={"Path to output file for Application Properties [nifi-registry.properties] with property protection applied"})
    Path outputApplicationPropertiesPath;
    @CommandLine.Option(names={"-i", "--identityProviders"}, description={"Path to file containing Identity Providers [identity-providers.xml] configuration that will be updated unless the output argument is provided"})
    Path identityProvidersPath;
    @CommandLine.Option(names={"-I", "--outputIdentityProviders"}, description={"Path to output file for Identity Providers [identity-providers.xml] with property protection applied"})
    Path outputIdentityProvidersPath;

    @Override
    public void run() {
        ApplicationProperties applicationProperties = this.loadApplicationProperties();
        this.processBootstrapConf(BOOTSTRAP_ROOT_KEY_PROPERTY);
        this.processApplicationProperties(applicationProperties);
        this.processAuthorizers();
        this.processIdentityProviders();
    }

    private ApplicationProperties loadApplicationProperties() {
        ApplicationProperties applicationProperties;
        if (this.applicationPropertiesPath == null) {
            applicationProperties = new ApplicationProperties(Collections.emptyMap());
            if (this.verboseModeEnabled) {
                this.logger.info("Application Properties [nifi-registry.properties] not specified");
            }
        } else {
            if (Files.notExists(this.applicationPropertiesPath, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("Application Properties [nifi-registry.properties] not found [%s]", this.applicationPropertiesPath));
            }
            NiFiRegistryPropertiesLoader propertiesLoader = new NiFiRegistryPropertiesLoader();
            String inputRootKey = this.getInputRootKey();
            String rootKey = inputRootKey == null ? this.getRootKey() : inputRootKey;
            propertiesLoader.setKeyHex(rootKey);
            applicationProperties = propertiesLoader.load(this.applicationPropertiesPath.toFile());
        }
        return applicationProperties;
    }

    private void processApplicationProperties(ApplicationProperties applicationProperties) {
        if (this.applicationPropertiesPath == null) {
            if (this.verboseModeEnabled) {
                this.logger.info("Application Properties [nifi-registry.properties] not specified");
            }
        } else {
            this.logger.info("Started processing Application Properties [{}]", (Object)this.applicationPropertiesPath);
            SensitivePropertyProviderFactory sensitivePropertyProviderFactory = this.getSensitivePropertyProviderFactory();
            SensitivePropertyProvider sensitivePropertyProvider = sensitivePropertyProviderFactory.getProvider(this.protectionScheme);
            Set<String> sensitivePropertyNames = this.getSensitivePropertyNames();
            ApplicationPropertiesFileTransformer fileTransformer = new ApplicationPropertiesFileTransformer(applicationProperties, sensitivePropertyProvider, sensitivePropertyNames);
            this.runFileTransformer(fileTransformer, this.applicationPropertiesPath, this.outputApplicationPropertiesPath);
            this.logger.info("Completed processing Application Properties [{}]", (Object)this.applicationPropertiesPath);
        }
    }

    private void processIdentityProviders() {
        if (this.identityProvidersPath == null) {
            if (this.verboseModeEnabled) {
                this.logger.info("Identity Providers not specified");
            }
        } else {
            this.logger.info("Started processing Identity Providers [{}]", (Object)this.identityProvidersPath);
            SensitivePropertyProvider inputSensitivePropertyProvider = this.getInputSensitivePropertyProvider();
            SensitivePropertyProviderFactory sensitivePropertyProviderFactory = this.getSensitivePropertyProviderFactory();
            XmlFileTransformer fileTransformer = new XmlFileTransformer(inputSensitivePropertyProvider, sensitivePropertyProviderFactory, this.protectionScheme);
            this.runFileTransformer(fileTransformer, this.identityProvidersPath, this.outputIdentityProvidersPath);
            this.logger.info("Completed processing Identity Providers [{}]", (Object)this.identityProvidersPath);
        }
    }

    private Set<String> getSensitivePropertyNames() {
        ApplicationPropertiesProtector protector = new ApplicationPropertiesProtector((ProtectedProperties)new ProtectedNiFiRegistryProperties());
        return Set.copyOf(protector.getSensitivePropertyKeys());
    }
}

