/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.config;

import java.util.Arrays;
import org.apache.nifi.toolkit.config.command.RegistryEncryptConfig;
import org.apache.nifi.toolkit.config.command.SharedEncryptConfig;
import org.apache.nifi.toolkit.config.command.StandardEncryptConfig;
import picocli.CommandLine;

public class EncryptConfigCommand {
    private static final String NIFI_REGISTRY_ARGUMENT = "--nifiRegistry";

    public static void main(String[] arguments) {
        String[] filteredArguments;
        SharedEncryptConfig command;
        if (EncryptConfigCommand.isRegistryModeRequested(arguments)) {
            command = new RegistryEncryptConfig();
            filteredArguments = EncryptConfigCommand.getFilteredArguments(arguments);
        } else {
            command = new StandardEncryptConfig();
            filteredArguments = arguments;
        }
        CommandLine commandLine = new CommandLine((Object)command);
        if (filteredArguments.length == 0) {
            commandLine.usage(System.out);
        } else {
            int status = commandLine.execute(filteredArguments);
            System.exit(status);
        }
    }

    private static boolean isRegistryModeRequested(String[] arguments) {
        boolean registryModeRequested = false;
        for (String argument : arguments) {
            if (!NIFI_REGISTRY_ARGUMENT.equals(argument)) continue;
            registryModeRequested = true;
            break;
        }
        return registryModeRequested;
    }

    private static String[] getFilteredArguments(String[] arguments) {
        return Arrays.stream(arguments).filter(argument -> !NIFI_REGISTRY_ARGUMENT.equals(argument)).toList().toArray(new String[0]);
    }
}

