/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.properties.ApplicationPropertiesProtector;
import org.apache.nifi.properties.ProtectedProperties;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProtector;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedNiFiRegistryProperties
extends NiFiRegistryProperties
implements ProtectedProperties<NiFiRegistryProperties>,
SensitivePropertyProtector<ProtectedNiFiRegistryProperties, NiFiRegistryProperties> {
    private static final Logger logger = LoggerFactory.getLogger(ProtectedNiFiRegistryProperties.class);
    private SensitivePropertyProtector<ProtectedNiFiRegistryProperties, NiFiRegistryProperties> propertyProtectionDelegate;
    private NiFiRegistryProperties applicationProperties;
    public static final String ADDITIONAL_SENSITIVE_PROPERTIES_KEY = "nifi.registry.sensitive.props.additional.keys";
    public static final List<String> DEFAULT_SENSITIVE_PROPERTIES = new ArrayList<String>(Arrays.asList("nifi.registry.security.keyPasswd", "nifi.registry.security.keystorePasswd", "nifi.registry.security.truststorePasswd", "nifi.registry.security.user.oidc.client.secret"));

    public ProtectedNiFiRegistryProperties() {
        this(new NiFiRegistryProperties());
    }

    public ProtectedNiFiRegistryProperties(NiFiRegistryProperties props) {
        this.applicationProperties = props;
        this.propertyProtectionDelegate = new ApplicationPropertiesProtector((ProtectedProperties)this);
        logger.debug("Loaded {} properties (including {} protection schemes) into ProtectedNiFiRegistryProperties", (Object)this.getApplicationProperties().getPropertyKeys().size(), (Object)this.getProtectedPropertyKeys().size());
    }

    public String getAdditionalSensitivePropertiesKeys() {
        return this.getProperty(this.getAdditionalSensitivePropertiesKeysName());
    }

    public String getAdditionalSensitivePropertiesKeysName() {
        return ADDITIONAL_SENSITIVE_PROPERTIES_KEY;
    }

    public List<String> getDefaultSensitiveProperties() {
        return DEFAULT_SENSITIVE_PROPERTIES;
    }

    public NiFiRegistryProperties getApplicationProperties() {
        if (this.applicationProperties == null) {
            this.applicationProperties = new NiFiRegistryProperties();
        }
        return this.applicationProperties;
    }

    public NiFiRegistryProperties createApplicationProperties(Properties rawProperties) {
        return new NiFiRegistryProperties(rawProperties);
    }

    public String getProperty(String key) {
        return this.getApplicationProperties().getProperty(key);
    }

    public Set<String> getPropertyKeys() {
        return this.propertyProtectionDelegate.getPropertyKeys();
    }

    public int size() {
        return this.propertyProtectionDelegate.size();
    }

    public Set<String> getPropertyKeysIncludingProtectionSchemes() {
        return this.propertyProtectionDelegate.getPropertyKeysIncludingProtectionSchemes();
    }

    public List<String> getSensitivePropertyKeys() {
        return this.propertyProtectionDelegate.getSensitivePropertyKeys();
    }

    public List<String> getPopulatedSensitivePropertyKeys() {
        return this.propertyProtectionDelegate.getPopulatedSensitivePropertyKeys();
    }

    public boolean hasProtectedKeys() {
        return this.propertyProtectionDelegate.hasProtectedKeys();
    }

    public Map<String, String> getProtectedPropertyKeys() {
        return this.propertyProtectionDelegate.getProtectedPropertyKeys();
    }

    public boolean isPropertySensitive(String key) {
        return this.propertyProtectionDelegate.isPropertySensitive(key);
    }

    public boolean isPropertyProtected(String key) {
        return this.propertyProtectionDelegate.isPropertyProtected(key);
    }

    public NiFiRegistryProperties getUnprotectedProperties() throws SensitivePropertyProtectionException {
        return (NiFiRegistryProperties)this.propertyProtectionDelegate.getUnprotectedProperties();
    }

    public void addSensitivePropertyProvider(SensitivePropertyProvider sensitivePropertyProvider) {
        this.propertyProtectionDelegate.addSensitivePropertyProvider(sensitivePropertyProvider);
    }

    public String toString() {
        return String.format("%s Size [%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.size());
    }
}

