/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardUserDefinedTypeExporter
implements Exporter<UserDefinedType> {
    protected final Dialect dialect;

    public StandardUserDefinedTypeExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlCreateStrings(UserDefinedType userDefinedType, Metadata metadata, SqlStringGenerationContext context) {
        QualifiedNameParser.NameParts typeName = new QualifiedNameParser.NameParts(Identifier.toIdentifier(userDefinedType.getCatalog(), userDefinedType.isCatalogQuoted()), Identifier.toIdentifier(userDefinedType.getSchema(), userDefinedType.isSchemaQuoted()), userDefinedType.getNameIdentifier());
        try {
            String formattedTypeName = context.format(typeName);
            StringBuilder buf = new StringBuilder("create type ").append(formattedTypeName).append(" as ").append(this.dialect.getCreateUserDefinedTypeKindString()).append('(');
            boolean isFirst = true;
            for (Column col : userDefinedType.getColumns()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                String colName = col.getQuotedName(this.dialect);
                buf.append(colName);
                buf.append(' ').append(col.getSqlType(metadata));
            }
            buf.append(')');
            this.applyUserDefinedTypeExtensionsString(buf);
            ArrayList<String> sqlStrings = new ArrayList<String>();
            sqlStrings.add(buf.toString());
            this.applyComments(userDefinedType, formattedTypeName, sqlStrings);
            return sqlStrings.toArray(StringHelper.EMPTY_STRINGS);
        }
        catch (Exception e) {
            throw new MappingException("Error creating SQL create commands for UDT : " + typeName, e);
        }
    }

    protected void applyComments(UserDefinedType udt, String formattedTypeName, List<String> sqlStrings) {
        if (this.dialect.supportsCommentOn()) {
            if (udt.getComment() != null) {
                sqlStrings.add("comment on type " + formattedTypeName + " is '" + udt.getComment() + "'");
            }
            for (Column column : udt.getColumns()) {
                String columnComment = column.getComment();
                if (columnComment == null) continue;
                sqlStrings.add("comment on column " + formattedTypeName + "." + column.getQuotedName(this.dialect) + " is '" + columnComment + "'");
            }
        }
    }

    protected void applyUserDefinedTypeExtensionsString(StringBuilder buf) {
        buf.append(this.dialect.getCreateUserDefinedTypeExtensionsString());
    }

    @Override
    public String[] getSqlDropStrings(UserDefinedType table, Metadata metadata, SqlStringGenerationContext context) {
        StringBuilder buf = new StringBuilder("drop type ");
        if (this.dialect.supportsIfExistsBeforeTypeName()) {
            buf.append("if exists ");
        }
        QualifiedNameParser.NameParts typeName = new QualifiedNameParser.NameParts(Identifier.toIdentifier(table.getCatalog(), table.isCatalogQuoted()), Identifier.toIdentifier(table.getSchema(), table.isSchemaQuoted()), table.getNameIdentifier());
        buf.append(context.format(typeName));
        if (this.dialect.supportsIfExistsAfterTypeName()) {
            buf.append(" if exists");
        }
        return new String[]{buf.toString()};
    }
}

