/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.resource;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.nifi.registry.security.authorization.AuthorizationResult;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.Resource;
import org.apache.nifi.registry.security.authorization.exception.AccessDeniedException;
import org.apache.nifi.registry.security.authorization.resource.Authorizable;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicCheckingAuthorizable
implements Authorizable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicCheckingAuthorizable.class);
    private final Authorizable wrappedAuthorizable;
    private final BiFunction<Resource, RequestAction, Boolean> publicResourceCheck;

    public PublicCheckingAuthorizable(Authorizable wrappedAuthorizable, BiFunction<Resource, RequestAction, Boolean> publicResourceCheck) {
        this.wrappedAuthorizable = Objects.requireNonNull(wrappedAuthorizable);
        this.publicResourceCheck = Objects.requireNonNull(publicResourceCheck);
    }

    @Override
    public Authorizable getParentAuthorizable() {
        return this.wrappedAuthorizable.getParentAuthorizable();
    }

    @Override
    public Resource getResource() {
        return this.wrappedAuthorizable.getResource();
    }

    @Override
    public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        Boolean isPublicAccessAllowed;
        Resource resource = this.getResource();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Requested resource is {}", new Object[]{resource.getIdentifier()});
        }
        if ((isPublicAccessAllowed = this.publicResourceCheck.apply(resource, action)).booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Public access is allowed for {}", new Object[]{resource.getIdentifier()});
            }
            return AuthorizationResult.approved();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delegating to inheriting authorizable for {}", new Object[]{resource.getIdentifier()});
        }
        return this.wrappedAuthorizable.checkAuthorization(authorizer, action, user, resourceContext);
    }

    @Override
    public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        Boolean isPublicAccessAllowed;
        Resource resource = this.getResource();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Requested resource is {}", new Object[]{resource.getIdentifier()});
        }
        if ((isPublicAccessAllowed = this.publicResourceCheck.apply(resource, action)).booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Public access is allowed for {}", new Object[]{resource.getIdentifier()});
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delegating to inheriting authorizable for {}", new Object[]{resource.getIdentifier()});
        }
        this.wrappedAuthorizable.authorize(authorizer, action, user, resourceContext);
    }
}

