/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.file;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.annotation.AuthorizerContext;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.registry.security.authorization.file.FileAuthorizer;
import org.apache.nifi.registry.security.authorization.file.UserGroupHolder;
import org.apache.nifi.registry.security.authorization.file.tenants.generated.Group;
import org.apache.nifi.registry.security.authorization.file.tenants.generated.Groups;
import org.apache.nifi.registry.security.authorization.file.tenants.generated.Tenants;
import org.apache.nifi.registry.security.authorization.file.tenants.generated.User;
import org.apache.nifi.registry.security.authorization.file.tenants.generated.Users;
import org.apache.nifi.registry.security.authorization.util.UserGroupProviderUtils;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.apache.nifi.registry.util.PropertyValue;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileUserGroupProvider
implements ConfigurableUserGroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileUserGroupProvider.class);
    private static final String TENANTS_XSD = "/tenants.xsd";
    private static final String JAXB_TENANTS_PATH = "org.apache.nifi.registry.security.authorization.file.tenants.generated";
    private static final JAXBContext JAXB_TENANTS_CONTEXT = FileUserGroupProvider.initializeJaxbContext("org.apache.nifi.registry.security.authorization.file.tenants.generated");
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String USER_ELEMENT = "user";
    private static final String GROUP_USER_ELEMENT = "groupUser";
    private static final String GROUP_ELEMENT = "group";
    private static final String IDENTIFIER_ATTR = "identifier";
    private static final String IDENTITY_ATTR = "identity";
    private static final String NAME_ATTR = "name";
    static final String PROP_TENANTS_FILE = "Users File";
    private Schema tenantsSchema;
    private File tenantsFile;
    private Set<String> initialUserIdentities;
    private IdentityMapper identityMapper;
    private final AtomicReference<UserGroupHolder> userGroupHolder = new AtomicReference();

    private static JAXBContext initializeJaxbContext(String contextPath) {
        try {
            return JAXBContext.newInstance((String)contextPath, (ClassLoader)FileAuthorizer.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext: " + String.valueOf((Object)e));
        }
    }

    public void initialize(UserGroupProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.tenantsSchema = schemaFactory.newSchema(FileAuthorizer.class.getResource(TENANTS_XSD));
        }
        catch (Exception e) {
            throw new SecurityProviderCreationException((Throwable)e);
        }
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        try {
            PropertyValue tenantsPath = configurationContext.getProperty(PROP_TENANTS_FILE);
            if (StringUtils.isBlank((CharSequence)tenantsPath.getValue())) {
                throw new SecurityProviderCreationException("The users file must be specified.");
            }
            this.tenantsFile = new File(tenantsPath.getValue());
            if (!this.tenantsFile.exists()) {
                logger.info("Creating new users file at {}", new Object[]{this.tenantsFile.getAbsolutePath()});
                this.saveTenants(new Tenants());
            }
            this.initialUserIdentities = UserGroupProviderUtils.getInitialUserIdentities(configurationContext, this.identityMapper);
            this.load();
            logger.info(String.format("Users/Groups file loaded at %s", new Date().toString()));
        }
        catch (JAXBException | IllegalStateException | SecurityProviderCreationException | SAXException e) {
            throw new SecurityProviderCreationException(e);
        }
    }

    public Set<org.apache.nifi.registry.security.authorization.User> getUsers() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllUsers();
    }

    public synchronized org.apache.nifi.registry.security.authorization.User addUser(org.apache.nifi.registry.security.authorization.User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        User jaxbUser = this.createJAXBUser(user);
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        tenants.getUsers().getUser().add(jaxbUser);
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getUsersById().get(user.getIdentifier());
    }

    public org.apache.nifi.registry.security.authorization.User getUser(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        return holder.getUsersById().get(identifier);
    }

    public synchronized org.apache.nifi.registry.security.authorization.User updateUser(org.apache.nifi.registry.security.authorization.User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        List<User> users = tenants.getUsers().getUser();
        User updateUser = null;
        for (User jaxbUser : users) {
            if (!user.getIdentifier().equals(jaxbUser.getIdentifier())) continue;
            updateUser = jaxbUser;
            break;
        }
        if (updateUser == null) {
            return null;
        }
        updateUser.setIdentity(user.getIdentity());
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getUsersById().get(user.getIdentifier());
    }

    public org.apache.nifi.registry.security.authorization.User getUserByIdentity(String identity) throws AuthorizationAccessException {
        if (identity == null) {
            return null;
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        return holder.getUsersByIdentity().get(identity);
    }

    public synchronized org.apache.nifi.registry.security.authorization.User deleteUser(org.apache.nifi.registry.security.authorization.User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        return this.deleteUser(user.getIdentifier());
    }

    private synchronized org.apache.nifi.registry.security.authorization.User deleteUser(String userIdentifier) throws AuthorizationAccessException {
        if (userIdentifier == null) {
            throw new IllegalArgumentException("User identifier cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        org.apache.nifi.registry.security.authorization.User deletedUser = holder.getUsersById().get(userIdentifier);
        if (deletedUser == null) {
            return null;
        }
        Tenants tenants = holder.getTenants();
        block0: for (org.apache.nifi.registry.security.authorization.file.tenants.generated.Group group : tenants.getGroups().getGroup()) {
            Iterator<Group.User> groupUserIter = group.getUser().iterator();
            while (groupUserIter.hasNext()) {
                Group.User groupUser = groupUserIter.next();
                if (!groupUser.getIdentifier().equals(userIdentifier)) continue;
                groupUserIter.remove();
                continue block0;
            }
        }
        Iterator<User> iter = tenants.getUsers().getUser().iterator();
        while (iter.hasNext()) {
            User jaxbUser = iter.next();
            if (!userIdentifier.equals(jaxbUser.getIdentifier())) continue;
            iter.remove();
            break;
        }
        this.saveAndRefreshHolder(tenants);
        return deletedUser;
    }

    public Set<Group> getGroups() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllGroups();
    }

    public synchronized Group addGroup(Group group) throws AuthorizationAccessException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        org.apache.nifi.registry.security.authorization.file.tenants.generated.Group jaxbGroup = new org.apache.nifi.registry.security.authorization.file.tenants.generated.Group();
        jaxbGroup.setIdentifier(group.getIdentifier());
        jaxbGroup.setName(group.getName());
        for (String groupUser : group.getUsers()) {
            Group.User jaxbGroupUser = new Group.User();
            jaxbGroupUser.setIdentifier(groupUser);
            jaxbGroup.getUser().add(jaxbGroupUser);
        }
        tenants.getGroups().getGroup().add(jaxbGroup);
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getGroupsById().get(group.getIdentifier());
    }

    public Group getGroup(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        return this.userGroupHolder.get().getGroupsById().get(identifier);
    }

    public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
        UserGroupHolder holder = this.userGroupHolder.get();
        final org.apache.nifi.registry.security.authorization.User user = holder.getUser(identity);
        final Set<Group> groups = holder.getGroups(identity);
        return new UserAndGroups(){

            public org.apache.nifi.registry.security.authorization.User getUser() {
                return user;
            }

            public Set<Group> getGroups() {
                return groups;
            }
        };
    }

    public synchronized Group updateGroup(Group group) throws AuthorizationAccessException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        org.apache.nifi.registry.security.authorization.file.tenants.generated.Group updateGroup = null;
        for (org.apache.nifi.registry.security.authorization.file.tenants.generated.Group jaxbGroup : tenants.getGroups().getGroup()) {
            if (!jaxbGroup.getIdentifier().equals(group.getIdentifier())) continue;
            updateGroup = jaxbGroup;
            break;
        }
        if (updateGroup == null) {
            return null;
        }
        updateGroup.getUser().clear();
        for (String groupUser : group.getUsers()) {
            Group.User jaxbGroupUser = new Group.User();
            jaxbGroupUser.setIdentifier(groupUser);
            updateGroup.getUser().add(jaxbGroupUser);
        }
        updateGroup.setName(group.getName());
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getGroupsById().get(group.getIdentifier());
    }

    public synchronized Group deleteGroup(Group group) throws AuthorizationAccessException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        return this.deleteGroup(group.getIdentifier());
    }

    private synchronized Group deleteGroup(String groupIdentifier) throws AuthorizationAccessException {
        if (groupIdentifier == null) {
            throw new IllegalArgumentException("Group identifier cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Group deletedGroup = holder.getGroupsById().get(groupIdentifier);
        if (deletedGroup == null) {
            return null;
        }
        Tenants tenants = holder.getTenants();
        Iterator<org.apache.nifi.registry.security.authorization.file.tenants.generated.Group> iter = tenants.getGroups().getGroup().iterator();
        while (iter.hasNext()) {
            org.apache.nifi.registry.security.authorization.file.tenants.generated.Group jaxbGroup = iter.next();
            if (!groupIdentifier.equals(jaxbGroup.getIdentifier())) continue;
            iter.remove();
            break;
        }
        this.saveAndRefreshHolder(tenants);
        return deletedGroup;
    }

    UserGroupHolder getUserGroupHolder() {
        return this.userGroupHolder.get();
    }

    @AuthorizerContext
    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    public synchronized void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        UsersAndGroups usersAndGroups = this.parseUsersAndGroups(fingerprint);
        usersAndGroups.getUsers().forEach(user -> this.addUser((org.apache.nifi.registry.security.authorization.User)user));
        usersAndGroups.getGroups().forEach(group -> this.addGroup((Group)group));
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException {
        try {
            this.parseUsersAndGroups(proposedFingerprint);
        }
        catch (AuthorizationAccessException e) {
            throw new UninheritableAuthorizationsException("Unable to parse the proposed fingerprint: " + String.valueOf((Object)e));
        }
        UserGroupHolder usersAndGroups = this.userGroupHolder.get();
        if (!usersAndGroups.getAllUsers().isEmpty() || !usersAndGroups.getAllGroups().isEmpty()) {
            throw new UninheritableAuthorizationsException("Proposed fingerprint is not inheritable because the current users and groups is not empty.");
        }
    }

    public String getFingerprint() throws AuthorizationAccessException {
        UserGroupHolder usersAndGroups = this.userGroupHolder.get();
        ArrayList<org.apache.nifi.registry.security.authorization.User> users = new ArrayList<org.apache.nifi.registry.security.authorization.User>(usersAndGroups.getAllUsers());
        Collections.sort(users, Comparator.comparing(org.apache.nifi.registry.security.authorization.User::getIdentifier));
        ArrayList<Group> groups = new ArrayList<Group>(usersAndGroups.getAllGroups());
        Collections.sort(groups, Comparator.comparing(Group::getIdentifier));
        XMLStreamWriter writer = null;
        StringWriter out = new StringWriter();
        try {
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("tenants");
            for (org.apache.nifi.registry.security.authorization.User user : users) {
                this.writeUser(writer, user);
            }
            for (Group group : groups) {
                this.writeGroup(writer, group);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new AuthorizationAccessException("Unable to generate fingerprint", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return out.toString();
    }

    private UsersAndGroups parseUsersAndGroups(String fingerprint) {
        ArrayList<org.apache.nifi.registry.security.authorization.User> users = new ArrayList<org.apache.nifi.registry.security.authorization.User>();
        ArrayList<Group> groups = new ArrayList<Group>();
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(fingerprintBytes);){
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            Document document = documentProvider.parse((InputStream)in);
            Element rootElement = document.getDocumentElement();
            NodeList userNodes = rootElement.getElementsByTagName(USER_ELEMENT);
            for (int i = 0; i < userNodes.getLength(); ++i) {
                Node userNode = userNodes.item(i);
                users.add(this.parseUser((Element)userNode));
            }
            NodeList groupNodes = rootElement.getElementsByTagName(GROUP_ELEMENT);
            for (int i = 0; i < groupNodes.getLength(); ++i) {
                Node groupNode = groupNodes.item(i);
                groups.add(this.parseGroup((Element)groupNode));
            }
        }
        catch (IOException | ProcessingException e) {
            throw new AuthorizationAccessException("Unable to parse fingerprint", e);
        }
        return new UsersAndGroups(users, groups);
    }

    private org.apache.nifi.registry.security.authorization.User parseUser(Element element) {
        User.Builder builder = new User.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).identity(element.getAttribute(IDENTITY_ATTR));
        return builder.build();
    }

    private Group parseGroup(Element element) {
        Group.Builder builder = new Group.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).name(element.getAttribute(NAME_ATTR));
        NodeList groupUsers = element.getElementsByTagName(GROUP_USER_ELEMENT);
        for (int i = 0; i < groupUsers.getLength(); ++i) {
            Element groupUserNode = (Element)groupUsers.item(i);
            builder.addUser(groupUserNode.getAttribute(IDENTIFIER_ATTR));
        }
        return builder.build();
    }

    private void writeUser(XMLStreamWriter writer, org.apache.nifi.registry.security.authorization.User user) throws XMLStreamException {
        writer.writeStartElement(USER_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, user.getIdentifier());
        writer.writeAttribute(IDENTITY_ATTR, user.getIdentity());
        writer.writeEndElement();
    }

    private void writeGroup(XMLStreamWriter writer, Group group) throws XMLStreamException {
        ArrayList users = new ArrayList(group.getUsers());
        Collections.sort(users);
        writer.writeStartElement(GROUP_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, group.getIdentifier());
        writer.writeAttribute(NAME_ATTR, group.getName());
        for (String user : users) {
            writer.writeStartElement(GROUP_USER_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, user);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private User createJAXBUser(org.apache.nifi.registry.security.authorization.User user) {
        User jaxbUser = new User();
        jaxbUser.setIdentifier(user.getIdentifier());
        jaxbUser.setIdentity(user.getIdentity());
        return jaxbUser;
    }

    private synchronized void load() throws JAXBException, IllegalStateException, SAXException {
        UserGroupHolder userGroupHolder;
        boolean emptyTenants;
        Tenants tenants = this.unmarshallTenants();
        if (tenants.getUsers() == null) {
            tenants.setUsers(new Users());
        }
        if (tenants.getGroups() == null) {
            tenants.setGroups(new Groups());
        }
        boolean bl = emptyTenants = (userGroupHolder = new UserGroupHolder(tenants)).getAllUsers().isEmpty() && userGroupHolder.getAllGroups().isEmpty();
        if (emptyTenants) {
            this.populateInitialUsers(tenants);
            this.saveAndRefreshHolder(tenants);
        } else {
            this.userGroupHolder.set(userGroupHolder);
        }
    }

    private void saveTenants(Tenants tenants) throws JAXBException {
        Marshaller marshaller = JAXB_TENANTS_CONTEXT.createMarshaller();
        marshaller.setSchema(this.tenantsSchema);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)tenants, this.tenantsFile);
    }

    private Tenants unmarshallTenants() throws JAXBException {
        Unmarshaller unmarshaller = JAXB_TENANTS_CONTEXT.createUnmarshaller();
        unmarshaller.setSchema(this.tenantsSchema);
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(this.tenantsFile), Tenants.class);
        return (Tenants)element.getValue();
    }

    private void populateInitialUsers(Tenants tenants) {
        for (String initialUserIdentity : this.initialUserIdentities) {
            this.getOrCreateUser(tenants, initialUserIdentity);
        }
    }

    private User getOrCreateUser(Tenants tenants, String userIdentity) {
        if (StringUtils.isBlank((CharSequence)userIdentity)) {
            return null;
        }
        User foundUser = null;
        for (User user : tenants.getUsers().getUser()) {
            if (!user.getIdentity().equals(userIdentity)) continue;
            foundUser = user;
            break;
        }
        if (foundUser == null) {
            org.apache.nifi.registry.security.authorization.User newUser = new User.Builder().identifierGenerateFromSeed(userIdentity).identity(userIdentity).build();
            foundUser = new User();
            foundUser.setIdentifier(newUser.getIdentifier());
            foundUser.setIdentity(newUser.getIdentity());
            tenants.getUsers().getUser().add(foundUser);
        }
        return foundUser;
    }

    private org.apache.nifi.registry.security.authorization.file.tenants.generated.Group getOrCreateGroup(Tenants tenants, String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            return null;
        }
        org.apache.nifi.registry.security.authorization.file.tenants.generated.Group foundGroup = null;
        for (org.apache.nifi.registry.security.authorization.file.tenants.generated.Group group : tenants.getGroups().getGroup()) {
            if (!group.getName().equals(groupName)) continue;
            foundGroup = group;
            break;
        }
        if (foundGroup == null) {
            Group newGroup = new Group.Builder().identifierGenerateFromSeed(groupName).name(groupName).build();
            foundGroup = new org.apache.nifi.registry.security.authorization.file.tenants.generated.Group();
            foundGroup.setIdentifier(newGroup.getIdentifier());
            foundGroup.setName(newGroup.getName());
            tenants.getGroups().getGroup().add(foundGroup);
        }
        return foundGroup;
    }

    private synchronized void saveAndRefreshHolder(Tenants tenants) throws AuthorizationAccessException {
        try {
            this.saveTenants(tenants);
            this.userGroupHolder.set(new UserGroupHolder(tenants));
        }
        catch (JAXBException e) {
            throw new AuthorizationAccessException("Unable to save Authorizations", (Throwable)e);
        }
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }

    private static class UsersAndGroups {
        final List<org.apache.nifi.registry.security.authorization.User> users;
        final List<Group> groups;

        public UsersAndGroups(List<org.apache.nifi.registry.security.authorization.User> users, List<Group> groups) {
            this.users = users;
            this.groups = groups;
        }

        public List<org.apache.nifi.registry.security.authorization.User> getUsers() {
            return this.users;
        }

        public List<Group> getGroups() {
            return this.groups;
        }
    }
}

