/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.flow;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.flow.FlowPersistenceException;
import org.apache.nifi.registry.flow.FlowPersistenceProvider;
import org.apache.nifi.registry.flow.FlowSnapshotContext;
import org.apache.nifi.registry.provider.ProviderConfigurationContext;
import org.apache.nifi.registry.provider.ProviderCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFlowPersistenceProvider
implements FlowPersistenceProvider {
    static final Logger LOGGER = LoggerFactory.getLogger(FileSystemFlowPersistenceProvider.class);
    static final String FLOW_STORAGE_DIR_PROP = "Flow Storage Directory";
    static final String SNAPSHOT_EXTENSION = ".snapshot";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private File flowStorageDir;

    public void onConfigured(ProviderConfigurationContext configurationContext) throws ProviderCreationException {
        Map props = configurationContext.getProperties();
        if (!props.containsKey(FLOW_STORAGE_DIR_PROP)) {
            throw new ProviderCreationException("The property Flow Storage Directory must be provided");
        }
        String flowStorageDirValue = (String)props.get(FLOW_STORAGE_DIR_PROP);
        if (StringUtils.isBlank((CharSequence)flowStorageDirValue)) {
            throw new ProviderCreationException("The property Flow Storage Directory cannot be null or blank");
        }
        try {
            this.flowStorageDir = new File(flowStorageDirValue);
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)this.flowStorageDir);
            LOGGER.info("Configured FileSystemFlowPersistenceProvider with Flow Storage Directory {}", (Object)this.flowStorageDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ProviderCreationException((Throwable)e);
        }
    }

    public synchronized void saveFlowContent(FlowSnapshotContext context, byte[] content) throws FlowPersistenceException {
        File bucketDir = this.getChildLocation(this.flowStorageDir, this.getNormalizedIdPath(context.getBucketId()));
        try {
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)bucketDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error accessing bucket directory at " + bucketDir.getAbsolutePath(), (Throwable)e);
        }
        File flowDir = this.getChildLocation(bucketDir, this.getNormalizedIdPath(context.getFlowId()));
        try {
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)flowDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error accessing flow directory at " + flowDir.getAbsolutePath(), (Throwable)e);
        }
        String versionString = String.valueOf(context.getVersion());
        File versionDir = this.getChildLocation(flowDir, Paths.get(versionString, new String[0]));
        try {
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)versionDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error accessing version directory at " + versionDir.getAbsolutePath(), (Throwable)e);
        }
        String versionExtension = versionString + SNAPSHOT_EXTENSION;
        File versionFile = this.getChildLocation(versionDir, Paths.get(versionExtension, new String[0]));
        if (versionFile.exists()) {
            throw new FlowPersistenceException("Unable to save, a snapshot already exists with version " + versionString);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Saving snapshot with filename {}", (Object)versionFile.getAbsolutePath());
        }
        try (FileOutputStream out = new FileOutputStream(versionFile);){
            ((OutputStream)out).write(content);
            out.flush();
        }
        catch (Exception e) {
            throw new FlowPersistenceException("Unable to write snapshot to disk", (Throwable)e);
        }
    }

    public synchronized byte[] getFlowContent(String bucketId, String flowId, int version) throws FlowPersistenceException {
        byte[] byArray;
        File snapshotFile = this.getSnapshotFile(bucketId, flowId, version);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Retrieving snapshot with filename {}", (Object)snapshotFile.getAbsolutePath());
        }
        if (!snapshotFile.exists()) {
            return null;
        }
        FileInputStream in = new FileInputStream(snapshotFile);
        try {
            byArray = IOUtils.toByteArray((InputStream)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FlowPersistenceException("Error reading snapshot file: " + snapshotFile.getAbsolutePath(), (Throwable)e);
            }
        }
        ((InputStream)in).close();
        return byArray;
    }

    public synchronized void deleteAllFlowContent(String bucketId, String flowId) throws FlowPersistenceException {
        boolean deletedBucket;
        File bucketDir;
        File[] bucketFiles;
        Path flowIdPath;
        Path bucketIdPath = this.getNormalizedIdPath(bucketId);
        Path bucketFlowPath = bucketIdPath.resolve(flowIdPath = this.getNormalizedIdPath(flowId));
        File flowDir = this.getChildLocation(this.flowStorageDir, bucketFlowPath);
        if (!flowDir.exists()) {
            LOGGER.debug("Snapshot directory does not exist at {}", (Object)flowDir.getAbsolutePath());
            return;
        }
        try {
            FileUtils.cleanDirectory((File)flowDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error deleting snapshots at " + flowDir.getAbsolutePath(), (Throwable)e);
        }
        boolean flowDirDeleted = flowDir.delete();
        if (!flowDirDeleted) {
            LOGGER.error("Unable to delete flow directory: " + flowDir.getAbsolutePath());
        }
        if (!((bucketFiles = (bucketDir = this.getChildLocation(this.flowStorageDir, this.getNormalizedIdPath(bucketId))).listFiles()) != null && bucketFiles.length != 0 || (deletedBucket = bucketDir.delete()))) {
            LOGGER.error("Unable to delete bucket directory: {}", (Object)flowDir.getAbsolutePath());
        }
    }

    public synchronized void deleteFlowContent(String bucketId, String flowId, int version) throws FlowPersistenceException {
        File snapshotFile = this.getSnapshotFile(bucketId, flowId, version);
        if (!snapshotFile.exists()) {
            LOGGER.debug("Snapshot file does not exist at {}", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        boolean deleted = snapshotFile.delete();
        if (!deleted) {
            throw new FlowPersistenceException("Unable to delete snapshot at " + snapshotFile.getAbsolutePath());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted snapshot at {}", (Object)snapshotFile.getAbsolutePath());
        }
    }

    protected File getSnapshotFile(String bucketId, String flowId, int version) {
        String versionExtension = version + SNAPSHOT_EXTENSION;
        Path snapshotLocation = Paths.get(this.getNormalizedId(bucketId), this.getNormalizedId(flowId), Integer.toString(version), versionExtension);
        return this.getChildLocation(this.flowStorageDir, snapshotLocation);
    }

    private File getChildLocation(File parentDir, Path childLocation) {
        Path childPathNormalized;
        Path parentPath = parentDir.toPath().normalize();
        Path childPath = parentPath.resolve(childPathNormalized = childLocation.normalize());
        if (childPath.startsWith(parentPath)) {
            return childPath.toFile();
        }
        throw new IllegalArgumentException(String.format("Child location not valid [%s]", childLocation));
    }

    private Path getNormalizedIdPath(String id) {
        String normalizedId = this.getNormalizedId(id);
        return Paths.get(normalizedId, new String[0]).normalize();
    }

    private String getNormalizedId(String input) {
        String sanitized = org.apache.nifi.registry.util.FileUtils.sanitizeFilename((String)input).trim().toLowerCase();
        Matcher matcher = NUMBER_PATTERN.matcher(sanitized);
        if (matcher.matches()) {
            int normalized = Integer.parseInt(sanitized);
            return Integer.toString(normalized);
        }
        UUID normalized = UUID.fromString(input);
        return normalized.toString();
    }
}

