/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.jetty.handler;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.jetty.handler.HandlerProvider;
import org.apache.nifi.registry.jetty.handler.HeaderWriterHandler;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.security.crypto.CryptoKeyProvider;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;

public class StandardHandlerProvider
implements HandlerProvider {
    private static final int MAX_FORM_CONTENT_SIZE = 600000;
    private static final String UI_CONTEXT_PATH = "/nifi-registry";
    private static final Pattern UI_FILE_PATTERN = Pattern.compile("^nifi-registry-web-ui-.+?\\.war$");
    private static final String API_CONTEXT_PATH = "/nifi-registry-api";
    private static final Pattern API_FILE_PATTERN = Pattern.compile("^nifi-registry-web-api-.+?\\.war$");
    private static final String DOCS_CONTEXT_PATH = "/nifi-registry-docs";
    private static final Pattern DOCS_FILE_PATTERN = Pattern.compile("^nifi-registry-web-docs-.+?\\.war$");
    private static final String HTML_DOCS_PATH = "/html/*";
    private static final String HTML_DOCS_RELATIVE_DIRECTORY = "html";
    private static final String REST_API_DOCS_PATH = "/rest-api/*";
    private static final String REST_API_DOCS_RELATIVE_PATH = "webapp/docs/rest-api";
    private static final String OIDC_SUPPORTED_PARAMETER = "oidc-supported";
    private static final String PROPERTIES_PARAMETER = "nifi-registry.properties";
    private static final String KEY_PROVIDER_PARAMETER = "nifi-registry.key";
    private static final String RESOURCE_BASE_PARAMETER = "baseResource";
    private static final String DIR_ALLOWED_PARAMETER = "dirAllowed";
    private static final String WEB_INF_JAR_PATTERN_ATTRIBUTE = "org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern";
    private static final String WEB_INF_JAR_PATTERN = ".*/spring-[^/]*\\.jar$";
    private static final String CONTAINER_JAR_PATTERN = ".*/jetty-jakarta-servlet-api-[^/]*\\.jar$|.*jakarta.servlet.jsp.jstl-[^/]*\\.jar";
    private final CryptoKeyProvider cryptoKeyProvider;
    private final String docsDirectory;

    public StandardHandlerProvider(CryptoKeyProvider cryptoKeyProvider, String docsDirectory) {
        this.cryptoKeyProvider = Objects.requireNonNull(cryptoKeyProvider, "Key Provider required");
        this.docsDirectory = docsDirectory;
    }

    @Override
    public Handler getHandler(NiFiRegistryProperties properties) {
        Objects.requireNonNull(properties, "Properties required");
        File libDirectory = properties.getWarLibDirectory();
        File workDirectory = properties.getWebWorkingDirectory();
        ContextHandlerCollection handlers = new ContextHandlerCollection(new ContextHandler[0]);
        handlers.addHandler((Handler)new HeaderWriterHandler());
        WebAppContext userInterfaceContext = this.getWebAppContext(libDirectory, workDirectory, ClassLoader.getSystemClassLoader(), UI_FILE_PATTERN, UI_CONTEXT_PATH);
        userInterfaceContext.setInitParameter(OIDC_SUPPORTED_PARAMETER, Boolean.toString(properties.isOidcEnabled()));
        handlers.addHandler((Handler)userInterfaceContext);
        ClassLoader apiClassLoader = this.getApiClassLoader(properties.getDatabaseDriverDirectory());
        WebAppContext apiContext = this.getWebAppContext(libDirectory, workDirectory, apiClassLoader, API_FILE_PATTERN, API_CONTEXT_PATH);
        apiContext.setAttribute(PROPERTIES_PARAMETER, (Object)properties);
        apiContext.setAttribute(KEY_PROVIDER_PARAMETER, (Object)this.cryptoKeyProvider);
        handlers.addHandler((Handler)apiContext);
        WebAppContext docsContext = this.getWebAppContext(libDirectory, workDirectory, ClassLoader.getSystemClassLoader(), DOCS_FILE_PATTERN, DOCS_CONTEXT_PATH);
        Path docsDir = this.getDocsDirectory();
        ServletHolder docsServletHolder = this.getDocsServletHolder(docsDir);
        docsContext.addServlet(docsServletHolder, HTML_DOCS_PATH);
        Path apiDocsDir = this.getApiDocsDirectory(apiContext);
        ServletHolder apiDocsServletHolder = this.getDocsServletHolder(apiDocsDir);
        docsContext.addServlet(apiDocsServletHolder, REST_API_DOCS_PATH);
        handlers.addHandler((Handler)docsContext);
        return handlers;
    }

    private ClassLoader getApiClassLoader(String databaseDriverDirectory) {
        URL[] resourceLocations = this.getResourceLocations(databaseDriverDirectory);
        ClassLoader apiClassLoader = resourceLocations.length == 0 ? ClassLoader.getSystemClassLoader() : new URLClassLoader(resourceLocations, ClassLoader.getSystemClassLoader());
        return apiClassLoader;
    }

    private WebAppContext getWebAppContext(File libDirectory, File workDirectory, ClassLoader parentClassLoader, Pattern applicationFilePattern, String contextPath) {
        File applicationFile = this.getApplicationFile(libDirectory, applicationFilePattern);
        WebAppContext webAppContext = new WebAppContext(applicationFile.getPath(), contextPath);
        webAppContext.setContextPath(contextPath);
        webAppContext.setMaxFormContentSize(600000);
        webAppContext.setAttribute(WEB_INF_JAR_PATTERN_ATTRIBUTE, (Object)WEB_INF_JAR_PATTERN);
        webAppContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)CONTAINER_JAR_PATTERN);
        webAppContext.setErrorHandler((Request.Handler)this.getErrorHandler());
        File tempDirectory = this.getTempDirectory(workDirectory, applicationFile.getName());
        webAppContext.setTempDirectory(tempDirectory);
        WebAppClassLoader webAppClassLoader = new WebAppClassLoader(parentClassLoader, (WebAppClassLoader.Context)webAppContext);
        webAppContext.setClassLoader((ClassLoader)webAppClassLoader);
        return webAppContext;
    }

    private File getApplicationFile(File directory, Pattern filenamePattern) {
        File[] applicationFiles = directory.listFiles((file, filename) -> filenamePattern.matcher(filename).matches());
        if (applicationFiles == null || applicationFiles.length == 0) {
            throw new IllegalStateException(String.format("Required Application matching [%s] not found in directory [%s]", filenamePattern, directory));
        }
        return applicationFiles[0];
    }

    private ErrorPageErrorHandler getErrorHandler() {
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.setShowServlet(false);
        errorHandler.setShowStacks(false);
        errorHandler.setShowMessageInTitle(false);
        return errorHandler;
    }

    private File getTempDirectory(File webWorkingDirectory, String filename) {
        File tempDirectory = new File(webWorkingDirectory, filename);
        if (tempDirectory.isDirectory()) {
            if (tempDirectory.canWrite()) {
                return tempDirectory;
            }
            throw new IllegalStateException(String.format("Temporary Directory [%s] not writable", tempDirectory));
        }
        if (tempDirectory.mkdirs()) {
            return tempDirectory;
        }
        throw new IllegalStateException(String.format("Temporary Directory [%s] creation failed", tempDirectory));
    }

    private URL[] getResourceLocations(String databaseDriverDirectory) {
        URL[] resourceLocations;
        if (StringUtils.isBlank((CharSequence)databaseDriverDirectory)) {
            resourceLocations = new URL[]{};
        } else {
            File driverDirectory = new File(databaseDriverDirectory);
            if (driverDirectory.canRead()) {
                ArrayList<URL> locations = new ArrayList<URL>();
                URL driverDirectoryUrl = this.getUrl(driverDirectory);
                locations.add(driverDirectoryUrl);
                File[] files = driverDirectory.listFiles();
                if (files != null) {
                    Arrays.stream(files).filter(File::isFile).map(this::getUrl).forEach(locations::add);
                }
                resourceLocations = locations.toArray(new URL[0]);
            } else {
                resourceLocations = new URL[]{};
            }
        }
        return resourceLocations;
    }

    private URL getUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(String.format("File URL [%s] conversion failed", file), e);
        }
    }

    private Path getDocsDirectory() {
        Path docsDir;
        block2: {
            Path docsDirectoryPath = Paths.get(this.docsDirectory, new String[0]);
            try {
                docsDir = docsDirectoryPath.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                docsDir = docsDirectoryPath;
                if (docsDir.toFile().mkdirs()) break block2;
                String message = String.format("Documentation Directory [%s] creation failed", this.docsDirectory);
                throw new IllegalStateException(message);
            }
        }
        return docsDir.resolve(HTML_DOCS_RELATIVE_DIRECTORY);
    }

    private ServletHolder getDocsServletHolder(Path directory) {
        ServletHolder servletHolder = new ServletHolder(directory.getFileName().toString(), DefaultServlet.class);
        servletHolder.setInitParameter(RESOURCE_BASE_PARAMETER, directory.toString());
        servletHolder.setInitParameter(DIR_ALLOWED_PARAMETER, Boolean.FALSE.toString());
        return servletHolder;
    }

    private Path getApiDocsDirectory(WebAppContext apiContext) {
        File apiDocsDir = new File(apiContext.getTempDirectory(), REST_API_DOCS_RELATIVE_PATH);
        if (apiDocsDir.canRead() || apiDocsDir.mkdirs()) {
            return apiDocsDir.toPath();
        }
        throw new IllegalStateException(String.format("REST API Documentation Directory [%s] not readable", apiDocsDir.getAbsolutePath()));
    }
}

