/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Component, EventEmitter, Input, Output } from '@angular/core';
import { CommonModule } from '@angular/common';
import { ParameterContextReferenceEntity } from '../../../../../state/shared';
import { NiFiCommon } from '../../../../../service/nifi-common.service';
import { RouterLink } from '@angular/router';

@Component({
    selector: 'parameter-provider-references',
    standalone: true,
    imports: [CommonModule, RouterLink],
    templateUrl: './parameter-providers-references.component.html',
    styleUrls: ['./parameter-providers-references.component.scss']
})
export class ParameterProviderReferences {
    @Input() parameterProviderReferences!: ParameterContextReferenceEntity[];
    @Output() goToParameterContext: EventEmitter<ParameterContextReferenceEntity> =
        new EventEmitter<ParameterContextReferenceEntity>();

    constructor(private nifiCommon: NiFiCommon) {}

    getUnauthorized(references: ParameterContextReferenceEntity[]) {
        return references.filter((p) => !p.permissions.canRead);
    }

    getAuthorized(references: ParameterContextReferenceEntity[]) {
        return references.filter((p) => p.permissions.canRead);
    }

    goToParameterContextClicked(event: MouseEvent, parameterContextReference: ParameterContextReferenceEntity) {
        event.stopPropagation();
        this.goToParameterContext.next(parameterContextReference);
    }
}
