/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.config.transformer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.minifi.toolkit.config.transformer.FileTransformer;

public class BootstrapConfigurationFileTransformer
implements FileTransformer {
    private static final Pattern PROPERTY_VALUE_PATTERN = Pattern.compile("^([^#!][^=]+?)\\s*=.*");
    private static final int NAME_GROUP = 1;
    private static final char PROPERTY_VALUE_SEPARATOR = '=';
    private final String rootKeyPropertyName;
    private final String rootKey;

    public BootstrapConfigurationFileTransformer(String rootKeyPropertyName, String rootKey) {
        this.rootKeyPropertyName = Objects.requireNonNull(rootKeyPropertyName, "Root Key Property Name required");
        this.rootKey = Objects.requireNonNull(rootKey, "Root Key required");
    }

    @Override
    public void transform(Path inputPath, Path outputPath) throws IOException {
        Objects.requireNonNull(inputPath, "Input path required");
        Objects.requireNonNull(outputPath, "Output path required");
        try (BufferedReader reader = Files.newBufferedReader(inputPath);
             BufferedWriter writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
            this.transform(reader, writer);
        }
    }

    private void transform(BufferedReader reader, BufferedWriter writer) throws IOException {
        boolean rootKeyPropertyNotFound = true;
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = PROPERTY_VALUE_PATTERN.matcher(line);
            if (matcher.matches()) {
                String name = matcher.group(1);
                if (this.rootKeyPropertyName.equals(name)) {
                    this.writeRootKey(writer);
                    rootKeyPropertyNotFound = false;
                } else {
                    writer.write(line);
                    writer.newLine();
                }
            } else {
                writer.write(line);
                writer.newLine();
            }
            line = reader.readLine();
        }
        if (rootKeyPropertyNotFound) {
            writer.newLine();
            this.writeRootKey(writer);
        }
    }

    private void writeRootKey(BufferedWriter writer) throws IOException {
        writer.write(this.rootKeyPropertyName);
        writer.write(61);
        writer.write(this.rootKey);
        writer.newLine();
    }
}

