/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.config.transformer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.minifi.toolkit.config.transformer.FileTransformer;
import org.apache.nifi.properties.ApplicationProperties;
import org.apache.nifi.properties.ApplicationPropertiesProtector;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProvider;

public class ApplicationPropertiesFileTransformer
implements FileTransformer {
    private static final Pattern PROPERTY_VALUE_PATTERN = Pattern.compile("^([^#!][^=]+?)\\s*=\\s?(.+)");
    private static final int NAME_GROUP = 1;
    private static final int VALUE_GROUP = 2;
    private static final char PROPERTY_VALUE_SEPARATOR = '=';
    private final ApplicationProperties applicationProperties;
    private final SensitivePropertyProvider outputSensitivePropertyProvider;
    private final Set<String> sensitivePropertyNames;

    public ApplicationPropertiesFileTransformer(ApplicationProperties applicationProperties, SensitivePropertyProvider outputSensitivePropertyProvider, Set<String> sensitivePropertyNames) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties, "Application Properties required");
        this.outputSensitivePropertyProvider = Objects.requireNonNull(outputSensitivePropertyProvider, "Output Property Provider required");
        this.sensitivePropertyNames = Objects.requireNonNull(sensitivePropertyNames, "Sensitive Property Names required");
    }

    @Override
    public void transform(Path inputPath, Path outputPath) throws IOException {
        Objects.requireNonNull(inputPath, "Input path required");
        Objects.requireNonNull(outputPath, "Output path required");
        try (BufferedReader reader = Files.newBufferedReader(inputPath);
             BufferedWriter writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
            this.transform(reader, writer);
        }
    }

    private void transform(BufferedReader reader, BufferedWriter writer) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = PROPERTY_VALUE_PATTERN.matcher(line);
            String nextLine = null;
            if (matcher.matches()) {
                nextLine = this.processPropertyLine(reader, writer, matcher, line);
            } else {
                this.writeNonSensitiveLine(writer, line);
            }
            line = nextLine == null ? reader.readLine() : nextLine;
        }
    }

    private String processPropertyLine(BufferedReader reader, BufferedWriter writer, Matcher matcher, String line) throws IOException {
        String actualPropertyName = matcher.group(1);
        String actualPropertyValue = matcher.group(2);
        String nextLine = null;
        if (!actualPropertyName.endsWith(".protected")) {
            nextLine = reader.readLine();
            if (this.sensitivePropertyNames.contains(actualPropertyName) || this.isNextPropertyProtected(actualPropertyName, nextLine)) {
                String applicationProperty = this.applicationProperties.getProperty(actualPropertyName, actualPropertyValue);
                this.writeProtectedProperty(writer, actualPropertyName, applicationProperty);
            } else {
                this.writeNonSensitiveLine(writer, line);
            }
        }
        return nextLine;
    }

    private void writeNonSensitiveLine(BufferedWriter writer, String line) throws IOException {
        writer.write(line);
        writer.newLine();
    }

    private boolean isNextPropertyProtected(String actualPropertyName, String nextLine) {
        Matcher nextLineMatcher;
        if (nextLine != null && (nextLineMatcher = PROPERTY_VALUE_PATTERN.matcher(nextLine)).matches()) {
            String protectedActualPropertyName = ApplicationPropertiesProtector.getProtectionKey((String)actualPropertyName);
            String nextName = nextLineMatcher.group(1);
            return protectedActualPropertyName.equals(nextName);
        }
        return false;
    }

    private void writeProtectedProperty(BufferedWriter writer, String name, String value) throws IOException {
        ProtectedPropertyContext propertyContext = ProtectedPropertyContext.defaultContext((String)name);
        String protectedValue = this.outputSensitivePropertyProvider.protect(value, propertyContext);
        writer.write(name);
        writer.write(61);
        this.writeNonSensitiveLine(writer, protectedValue);
        String protectedName = ApplicationPropertiesProtector.getProtectionKey((String)name);
        writer.write(protectedName);
        writer.write(61);
        String protectionIdentifierKey = this.outputSensitivePropertyProvider.getIdentifierKey();
        this.writeNonSensitiveLine(writer, protectionIdentifierKey);
    }
}

