/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathUpdateEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathPutEvaluator
extends JsonPathUpdateEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPathPutEvaluator.class);
    protected Evaluator<?> keyEvaluator;

    public JsonPathPutEvaluator(Evaluator<String> subject, Evaluator<String> jsonPathExp, Evaluator<?> valueEvaluator, Evaluator<?> keyEvaluator) {
        super(subject, jsonPathExp, valueEvaluator);
        this.keyEvaluator = keyEvaluator;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext context) {
        String result;
        DocumentContext documentContext = this.getDocumentContext(context);
        JsonPath compiledJsonPath = this.getJsonPath(context);
        Object value = this.valueEvaluator.evaluate(context).getValue();
        String key = this.keyEvaluator.evaluate(context).getValue().toString();
        try {
            result = documentContext.put(compiledJsonPath, key, value).jsonString();
        }
        catch (Exception e) {
            LOGGER.error("Failed to put value " + String.valueOf(value) + " at key " + key + " at path " + String.valueOf(compiledJsonPath) + " with error " + e.getLocalizedMessage(), (Throwable)e);
            return EMPTY_RESULT;
        }
        return new StringQueryResult(JsonPathPutEvaluator.getResultRepresentation(result, EMPTY_RESULT.getValue()));
    }
}

