/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.status;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.nifi.web.api.entity.ConnectionStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.PortStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusSnapshotEntity;

@XmlType(name="processGroupStatusSnapshot")
public class ProcessGroupStatusSnapshotDTO
implements Cloneable {
    private String id;
    private String name;
    private Collection<ConnectionStatusSnapshotEntity> connectionStatusSnapshots;
    private Collection<ProcessorStatusSnapshotEntity> processorStatusSnapshots;
    private Collection<ProcessGroupStatusSnapshotEntity> processGroupStatusSnapshots;
    private Collection<RemoteProcessGroupStatusSnapshotEntity> remoteProcessGroupStatusSnapshots;
    private Collection<PortStatusSnapshotEntity> inputPortStatusSnapshots;
    private Collection<PortStatusSnapshotEntity> outputPortStatusSnapshots;
    private String versionedFlowState;
    private int statelessActiveThreadCount;
    private Integer flowFilesIn = 0;
    private Long bytesIn = 0L;
    private String input;
    private Integer flowFilesQueued = 0;
    private Long bytesQueued = 0L;
    private String queued;
    private String queuedCount;
    private String queuedSize;
    private Long bytesRead = 0L;
    private String read;
    private Long bytesWritten = 0L;
    private String written;
    private Integer flowFilesOut = 0;
    private Long bytesOut = 0L;
    private String output;
    private Integer flowFilesTransferred = 0;
    private Long bytesTransferred = 0L;
    private String transferred;
    private Long bytesReceived = 0L;
    private Integer flowFilesReceived = 0;
    private String received;
    private Long bytesSent = 0L;
    private Integer flowFilesSent = 0;
    private String sent;
    private Integer activeThreadCount = 0;
    private Integer terminatedThreadCount = 0;
    private Long processingNanos = 0L;

    @Schema(description="The id of the process group.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The name of this process group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The current state of the Process Group, as it relates to the Versioned Flow", accessMode=Schema.AccessMode.READ_ONLY, allowableValues={"LOCALLY_MODIFIED, STALE, LOCALLY_MODIFIED_AND_STALE, UP_TO_DATE, SYNC_FAILURE"})
    public String getVersionedFlowState() {
        return this.versionedFlowState;
    }

    public void setVersionedFlowState(String versionedFlowState) {
        this.versionedFlowState = versionedFlowState;
    }

    @Schema(description="The current number of active threads for the Process Group, when running in Stateless mode.", accessMode=Schema.AccessMode.READ_ONLY)
    public int getStatelessActiveThreadCount() {
        return this.statelessActiveThreadCount;
    }

    public void setStatelessActiveThreadCount(int statelessActiveThreadCount) {
        this.statelessActiveThreadCount = statelessActiveThreadCount;
    }

    @Schema(description="The active thread count for this process group.")
    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    @Schema(description="The number of threads currently terminated for the process group.")
    public Integer getTerminatedThreadCount() {
        return this.terminatedThreadCount;
    }

    public void setTerminatedThreadCount(Integer terminatedThreadCount) {
        this.terminatedThreadCount = terminatedThreadCount;
    }

    @Schema(description="The status of all connections in the process group.")
    public Collection<ConnectionStatusSnapshotEntity> getConnectionStatusSnapshots() {
        return this.connectionStatusSnapshots;
    }

    public void setConnectionStatusSnapshots(Collection<ConnectionStatusSnapshotEntity> connectionStatus) {
        this.connectionStatusSnapshots = connectionStatus;
    }

    @Schema(description="The status of all process groups in the process group.")
    public Collection<ProcessGroupStatusSnapshotEntity> getProcessGroupStatusSnapshots() {
        return this.processGroupStatusSnapshots;
    }

    public void setProcessGroupStatusSnapshots(Collection<ProcessGroupStatusSnapshotEntity> processGroupStatus) {
        this.processGroupStatusSnapshots = processGroupStatus;
    }

    @Schema(description="The status of all remote process groups in the process group.")
    public Collection<RemoteProcessGroupStatusSnapshotEntity> getRemoteProcessGroupStatusSnapshots() {
        return this.remoteProcessGroupStatusSnapshots;
    }

    public void setRemoteProcessGroupStatusSnapshots(Collection<RemoteProcessGroupStatusSnapshotEntity> remoteProcessGroupStatus) {
        this.remoteProcessGroupStatusSnapshots = remoteProcessGroupStatus;
    }

    @Schema(description="The status of all processors in the process group.")
    public Collection<ProcessorStatusSnapshotEntity> getProcessorStatusSnapshots() {
        return this.processorStatusSnapshots;
    }

    public void setProcessorStatusSnapshots(Collection<ProcessorStatusSnapshotEntity> processorStatus) {
        this.processorStatusSnapshots = processorStatus;
    }

    @Schema(description="The status of all input ports in the process group.")
    public Collection<PortStatusSnapshotEntity> getInputPortStatusSnapshots() {
        return this.inputPortStatusSnapshots;
    }

    public void setInputPortStatusSnapshots(Collection<PortStatusSnapshotEntity> inputPortStatus) {
        this.inputPortStatusSnapshots = inputPortStatus;
    }

    @Schema(description="The status of all output ports in the process group.")
    public Collection<PortStatusSnapshotEntity> getOutputPortStatusSnapshots() {
        return this.outputPortStatusSnapshots;
    }

    public void setOutputPortStatusSnapshots(Collection<PortStatusSnapshotEntity> outputPortStatus) {
        this.outputPortStatusSnapshots = outputPortStatus;
    }

    @Schema(description="The output count/size for the process group in the last 5 minutes.")
    public String getOutput() {
        return this.output;
    }

    @Schema(description="The count/size transferred to/from queues in the process group in the last 5 minutes.")
    public String getTransferred() {
        return this.transferred;
    }

    @Schema(description="The count/size sent to the process group in the last 5 minutes.")
    public String getReceived() {
        return this.received;
    }

    @Schema(description="The count/size sent from this process group in the last 5 minutes.")
    public String getSent() {
        return this.sent;
    }

    @Schema(description="The count that is queued for the process group.")
    public String getQueuedCount() {
        return this.queuedCount;
    }

    @Schema(description="The size that is queued for the process group.")
    public String getQueuedSize() {
        return this.queuedSize;
    }

    @Schema(description="The count/size that is queued in the the process group.")
    public String getQueued() {
        return this.queued;
    }

    @Schema(description="The number of bytes read in the last 5 minutes.")
    public String getRead() {
        return this.read;
    }

    @Schema(description="The number of bytes written in the last 5 minutes.")
    public String getWritten() {
        return this.written;
    }

    @Schema(description="The input count/size for the process group in the last 5 minutes (pretty printed).")
    public String getInput() {
        return this.input;
    }

    @Schema(description="The number of FlowFiles that have come into this ProcessGroup in the last 5 minutes")
    public Integer getFlowFilesIn() {
        return this.flowFilesIn;
    }

    public void setFlowFilesIn(Integer flowFilesIn) {
        this.flowFilesIn = flowFilesIn;
    }

    @Schema(description="The number of bytes that have come into this ProcessGroup in the last 5 minutes")
    public Long getBytesIn() {
        return this.bytesIn;
    }

    public void setBytesIn(Long bytesIn) {
        this.bytesIn = bytesIn;
    }

    @Schema(description="The number of FlowFiles that are queued up in this ProcessGroup right now")
    public Integer getFlowFilesQueued() {
        return this.flowFilesQueued;
    }

    public void setFlowFilesQueued(Integer flowFilesQueued) {
        this.flowFilesQueued = flowFilesQueued;
    }

    @Schema(description="The number of bytes that are queued up in this ProcessGroup right now")
    public Long getBytesQueued() {
        return this.bytesQueued;
    }

    public void setBytesQueued(Long bytesQueued) {
        this.bytesQueued = bytesQueued;
    }

    @Schema(description="The number of bytes read by components in this ProcessGroup in the last 5 minutes")
    public Long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(Long bytesRead) {
        this.bytesRead = bytesRead;
    }

    @Schema(description="The number of bytes written by components in this ProcessGroup in the last 5 minutes")
    public Long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(Long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    @Schema(description="The number of FlowFiles transferred out of this ProcessGroup in the last 5 minutes")
    public Integer getFlowFilesOut() {
        return this.flowFilesOut;
    }

    public void setFlowFilesOut(Integer flowFilesOut) {
        this.flowFilesOut = flowFilesOut;
    }

    @Schema(description="The number of bytes transferred out of this ProcessGroup in the last 5 minutes")
    public Long getBytesOut() {
        return this.bytesOut;
    }

    public void setBytesOut(Long bytesOut) {
        this.bytesOut = bytesOut;
    }

    @Schema(description="The number of FlowFiles transferred in this ProcessGroup in the last 5 minutes")
    public Integer getFlowFilesTransferred() {
        return this.flowFilesTransferred;
    }

    public void setFlowFilesTransferred(Integer flowFilesTransferred) {
        this.flowFilesTransferred = flowFilesTransferred;
    }

    @Schema(description="The number of bytes transferred in this ProcessGroup in the last 5 minutes")
    public Long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public void setBytesTransferred(Long bytesTransferred) {
        this.bytesTransferred = bytesTransferred;
    }

    @Schema(description="The number of bytes received from external sources by components within this ProcessGroup in the last 5 minutes")
    public Long getBytesReceived() {
        return this.bytesReceived;
    }

    public void setBytesReceived(Long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    @Schema(description="The number of bytes sent to an external sink by components within this ProcessGroup in the last 5 minutes")
    public Long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(Long bytesSent) {
        this.bytesSent = bytesSent;
    }

    @Schema(description="The number of FlowFiles sent to an external sink by components within this ProcessGroup in the last 5 minutes")
    public Integer getFlowFilesSent() {
        return this.flowFilesSent;
    }

    public void setFlowFilesSent(Integer flowFilesSent) {
        this.flowFilesSent = flowFilesSent;
    }

    @Schema(description="The number of FlowFiles received from external sources by components within this ProcessGroup in the last 5 minutes")
    public Integer getFlowFilesReceived() {
        return this.flowFilesReceived;
    }

    public void setFlowFilesReceived(Integer flowFilesReceived) {
        this.flowFilesReceived = flowFilesReceived;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setQueued(String queued) {
        this.queued = queued;
    }

    public void setQueuedCount(String queuedCount) {
        this.queuedCount = queuedCount;
    }

    public void setQueuedSize(String queuedSize) {
        this.queuedSize = queuedSize;
    }

    public void setRead(String read) {
        this.read = read;
    }

    public void setWritten(String written) {
        this.written = written;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setTransferred(String transferred) {
        this.transferred = transferred;
    }

    public void setReceived(String received) {
        this.received = received;
    }

    public void setSent(String sent) {
        this.sent = sent;
    }

    public Long getProcessingNanos() {
        return this.processingNanos;
    }

    public void setProcessingNanos(Long processingNanos) {
        this.processingNanos = processingNanos;
    }

    public ProcessGroupStatusSnapshotDTO clone() {
        ProcessGroupStatusSnapshotDTO other = new ProcessGroupStatusSnapshotDTO();
        other.setId(this.getId());
        other.setName(this.getName());
        other.setVersionedFlowState(this.getVersionedFlowState());
        other.setStatelessActiveThreadCount(this.getStatelessActiveThreadCount());
        other.setBytesIn(this.getBytesIn());
        other.setFlowFilesIn(this.getFlowFilesIn());
        other.setInput(this.getInput());
        other.setBytesQueued(this.getBytesQueued());
        other.setFlowFilesQueued(this.getFlowFilesQueued());
        other.setQueued(this.getQueued());
        other.setQueuedCount(this.getQueuedCount());
        other.setQueuedSize(this.getQueuedSize());
        other.setBytesRead(this.getBytesRead());
        other.setRead(this.getRead());
        other.setBytesWritten(this.getBytesWritten());
        other.setWritten(this.getWritten());
        other.setBytesOut(this.getBytesOut());
        other.setFlowFilesOut(this.getFlowFilesOut());
        other.setOutput(this.getOutput());
        other.setBytesTransferred(this.getBytesTransferred());
        other.setFlowFilesTransferred(this.getFlowFilesTransferred());
        other.setTransferred(this.getTransferred());
        other.setBytesReceived(this.getBytesReceived());
        other.setFlowFilesReceived(this.getFlowFilesReceived());
        other.setReceived(this.getReceived());
        other.setBytesSent(this.getBytesSent());
        other.setFlowFilesSent(this.getFlowFilesSent());
        other.setSent(this.getSent());
        other.setActiveThreadCount(this.getActiveThreadCount());
        other.setTerminatedThreadCount(this.getTerminatedThreadCount());
        other.setProcessingNanos(this.getProcessingNanos());
        other.setConnectionStatusSnapshots(this.copy(this.getConnectionStatusSnapshots()));
        other.setProcessorStatusSnapshots(this.copy(this.getProcessorStatusSnapshots()));
        other.setRemoteProcessGroupStatusSnapshots(this.copy(this.getRemoteProcessGroupStatusSnapshots()));
        other.setInputPortStatusSnapshots(this.copy(this.getInputPortStatusSnapshots()));
        other.setOutputPortStatusSnapshots(this.copy(this.getOutputPortStatusSnapshots()));
        if (this.processGroupStatusSnapshots != null) {
            ArrayList<ProcessGroupStatusSnapshotEntity> childGroups = new ArrayList<ProcessGroupStatusSnapshotEntity>();
            for (ProcessGroupStatusSnapshotEntity procGroupStatus : this.processGroupStatusSnapshots) {
                childGroups.add(procGroupStatus.clone());
            }
            other.setProcessGroupStatusSnapshots(childGroups);
        }
        return other;
    }

    private <T> Collection<T> copy(Collection<T> original) {
        if (original == null) {
            return null;
        }
        return new ArrayList<T>(original);
    }
}

