/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Optional;
import java.util.Properties;

public class SensitivePropertyUtils {
    public static final String MINIFI_BOOTSTRAP_SENSITIVE_KEY = "minifi.bootstrap.sensitive.key";
    private static final String EMPTY = "";

    private SensitivePropertyUtils() {
    }

    public static String getFormattedKey() {
        String key = SensitivePropertyUtils.getKey(System.getProperty("minifi.bootstrap.conf.file.path"));
        return SensitivePropertyUtils.getFormattedKey(key);
    }

    public static String getFormattedKey(String unformattedKey) {
        String key = SensitivePropertyUtils.formatHexKey(unformattedKey);
        if (SensitivePropertyUtils.isNotEmpty(key) && !SensitivePropertyUtils.isHexKeyValid(key)) {
            throw new IllegalArgumentException("The key was not provided in valid hex format and of the correct length");
        }
        return key;
    }

    private static String formatHexKey(String input) {
        return Optional.ofNullable(input).map(String::trim).filter(SensitivePropertyUtils::isNotEmpty).map(str -> str.replaceAll("[^0-9a-fA-F]", EMPTY).toLowerCase()).orElse(EMPTY);
    }

    private static boolean isHexKeyValid(String key) {
        return Optional.ofNullable(key).map(String::trim).filter(SensitivePropertyUtils::isNotEmpty).filter(k -> k.matches("^[0-9a-fA-F]{64}$")).isPresent();
    }

    private static String getKey(String bootstrapConfigFilePath) {
        Properties properties = new Properties();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(bootstrapConfigFilePath));){
            properties.load(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Loading Bootstrap Properties [%s] failed", bootstrapConfigFilePath), e);
        }
        return properties.getProperty(MINIFI_BOOTSTRAP_SENSITIVE_KEY);
    }

    private static boolean isNotEmpty(String keyFilePath) {
        return keyFilePath != null && !keyFilePath.isBlank();
    }
}

