/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.minifi.MiNiFiServer;
import org.apache.nifi.minifi.commons.utils.SensitivePropertyUtils;
import org.apache.nifi.minifi.util.BootstrapClassLoaderUtils;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.NarUnpacker;
import org.apache.nifi.nar.SystemBundle;
import org.apache.nifi.util.FileUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class MiNiFi {
    private static final Logger logger = LoggerFactory.getLogger(MiNiFi.class);
    private final MiNiFiServer minifiServer;
    private volatile boolean shutdown = false;
    private static final String FRAMEWORK_NAR_ID = "minifi-framework-nar";

    public MiNiFi(NiFiProperties properties) throws ClassNotFoundException, IOException, IllegalArgumentException {
        this(properties, ClassLoader.getSystemClassLoader());
    }

    public MiNiFi(NiFiProperties properties, ClassLoader rootClassLoader) throws ClassNotFoundException, IOException, IllegalArgumentException {
        File kerberosConfigFile = properties.getKerberosConfigurationFile();
        if (kerberosConfigFile != null) {
            String kerberosConfigFilePath = kerberosConfigFile.getAbsolutePath();
            logger.info("Setting java.security.krb5.conf to {}", (Object)kerberosConfigFilePath);
            System.setProperty("java.security.krb5.conf", kerberosConfigFilePath);
        }
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            logger.error("An Unknown Error Occurred in Thread {}: {}", (Object)t, (Object)e.toString());
            logger.error("", e);
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdownHook(false)));
        File webWorkingDir = properties.getWebWorkingDirectory();
        FileUtils.deleteFilesInDirectory((File)webWorkingDir, null, (Logger)logger, (boolean)true, (boolean)true);
        FileUtils.deleteFile((File)webWorkingDir, (Logger)logger, (int)3);
        this.detectTimingIssues();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Bundle systemBundle = SystemBundle.create((NiFiProperties)properties, (ClassLoader)rootClassLoader);
        NarUnpackMode unpackMode = properties.isUnpackNarsToUberJar() ? NarUnpackMode.UNPACK_TO_UBER_JAR : NarUnpackMode.UNPACK_INDIVIDUAL_JARS;
        ExtensionMapping extensionMapping = NarUnpacker.unpackNars((NiFiProperties)properties, (String)FRAMEWORK_NAR_ID, (Bundle)systemBundle, (NarUnpackMode)unpackMode);
        NarClassLoaders narClassLoaders = NarClassLoadersHolder.getInstance();
        narClassLoaders.init(rootClassLoader, properties.getFrameworkWorkingDirectory(), properties.getExtensionsWorkingDirectory(), FRAMEWORK_NAR_ID, true);
        ClassLoader frameworkClassLoader = narClassLoaders.getFrameworkBundle().getClassLoader();
        if (frameworkClassLoader == null) {
            throw new IllegalStateException("Unable to find the framework NAR ClassLoader.");
        }
        Set narBundles = narClassLoaders.getBundles();
        long startTime = System.nanoTime();
        NiFiServer nifiServer = narClassLoaders.getServer();
        if (nifiServer == null) {
            throw new IllegalStateException("Unable to find a NiFiServer implementation.");
        }
        if (!(nifiServer instanceof MiNiFiServer)) {
            throw new IllegalStateException("Found NiFiServer implementation with class name " + nifiServer.getClass().getName() + ", it does not implement the required MiNiFiServer interface.");
        }
        this.minifiServer = (MiNiFiServer)nifiServer;
        Thread.currentThread().setContextClassLoader(this.minifiServer.getClass().getClassLoader());
        this.minifiServer.initialize(properties, systemBundle, narBundles, extensionMapping);
        if (this.shutdown) {
            logger.info("MiNiFi has been shutdown via MiNiFi Bootstrap. Will not start Controller");
        } else {
            this.minifiServer.start();
            long endTime = System.nanoTime();
            long durationNanos = endTime - startTime;
            float durationSeconds = (float)TimeUnit.MILLISECONDS.convert(durationNanos, TimeUnit.NANOSECONDS) / 1000.0f;
            logger.info("Controller initialization took {} nanoseconds ({} seconds).", (Object)durationNanos, (Object)String.format("%.01f", Float.valueOf(durationSeconds)));
        }
    }

    protected void shutdownHook(boolean isReload) {
        try {
            this.shutdown = true;
            logger.info("Initiating shutdown of MiNiFi server...");
            if (this.minifiServer != null) {
                this.minifiServer.stop();
            }
            logger.info("MiNiFi server shutdown completed (nicely or otherwise).");
        }
        catch (Throwable t) {
            logger.warn("Problem occurred ensuring MiNiFi server was properly terminated due to {}", (Object)t.getMessage());
        }
    }

    private void detectTimingIssues() {
        int minRequiredOccurrences = 25;
        int maxOccurrencesOutOfRange = 15;
        AtomicLong lastTriggerMillis = new AtomicLong(System.currentTimeMillis());
        final ScheduledExecutorService service = Executors.newScheduledThreadPool(1, new ThreadFactory(this){
            private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = this.defaultFactory.newThread(r);
                t.setDaemon(true);
                t.setName("Detect Timing Issues");
                return t;
            }
        });
        final AtomicInteger occurrencesOutOfRange = new AtomicInteger(0);
        final AtomicInteger occurrences = new AtomicInteger(0);
        Runnable command = () -> {
            long curMillis = System.currentTimeMillis();
            long difference = curMillis - lastTriggerMillis.get();
            long millisOff = Math.abs(difference - 2000L);
            occurrences.incrementAndGet();
            if (millisOff > 500L) {
                occurrencesOutOfRange.incrementAndGet();
            }
            lastTriggerMillis.set(curMillis);
        };
        final ScheduledFuture<?> future = service.scheduleWithFixedDelay(command, 2000L, 2000L, TimeUnit.MILLISECONDS);
        TimerTask timerTask = new TimerTask(this){

            @Override
            public void run() {
                future.cancel(true);
                service.shutdownNow();
                if (occurrences.get() < 25 || occurrencesOutOfRange.get() > 15) {
                    logger.warn("MiNiFi has detected that this box is not responding within the expected timing interval, which may cause Processors to be scheduled erratically. Please see the MiNiFi documentation for more information.");
                }
            }
        };
        Timer timer = new Timer(true);
        timer.schedule(timerTask, 60000L);
    }

    public static void main(String[] args) {
        logger.info("Launching MiNiFi...");
        try {
            NiFiProperties properties = MiNiFi.getValidatedMiNifiProperties();
            new MiNiFi(properties);
        }
        catch (Throwable t) {
            logger.error("Failure to launch MiNiFi due to " + String.valueOf(t), t);
        }
    }

    protected static NiFiProperties getValidatedMiNifiProperties() {
        NiFiProperties properties = MiNiFi.initializeProperties(BootstrapClassLoaderUtils.createBootstrapClassLoader());
        properties.validate();
        return properties;
    }

    private static NiFiProperties initializeProperties(ClassLoader boostrapLoader) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String key = SensitivePropertyUtils.getFormattedKey();
        Thread.currentThread().setContextClassLoader(boostrapLoader);
        try {
            Class<?> propsLoaderClass = Class.forName("org.apache.nifi.minifi.properties.MiNiFiPropertiesLoader", true, boostrapLoader);
            Constructor<?> constructor = propsLoaderClass.getDeclaredConstructor(String.class);
            Object loaderInstance = constructor.newInstance(key);
            Method getMethod = propsLoaderClass.getMethod("get", new Class[0]);
            NiFiProperties properties = (NiFiProperties)getMethod.invoke(loaderInstance, new Object[0]);
            logger.info("Application Properties loaded [{}]", (Object)properties.size());
            NiFiProperties niFiProperties = properties;
            return niFiProperties;
        }
        catch (InvocationTargetException wrappedException) {
            throw new IllegalArgumentException("There was an issue decrypting protected properties", wrappedException.getCause() == null ? wrappedException : wrappedException.getCause());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException reex) {
            throw new IllegalArgumentException("Unable to access properties loader in the expected manner - apparent classpath or build issue", reex);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("There was an issue decrypting protected properties", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

