/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.nar.AbstractNativeLibHandlingClassLoader;
import org.apache.nifi.nar.SharedInstanceClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceClassLoader
extends AbstractNativeLibHandlingClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(InstanceClassLoader.class);
    private final String identifier;
    private final String instanceType;
    private final Set<URL> instanceUrls;
    private final Set<URL> additionalResourceUrls;

    public InstanceClassLoader(String identifier, String type, Set<URL> instanceUrls, Set<URL> additionalResourceUrls, ClassLoader parent) {
        this(identifier, type, instanceUrls, additionalResourceUrls, Collections.emptySet(), parent);
    }

    public InstanceClassLoader(String identifier, String type, Set<URL> instanceUrls, Set<URL> additionalResourceUrls, Set<File> narNativeLibDirs, ClassLoader parent) {
        super(InstanceClassLoader.combineURLs(instanceUrls, additionalResourceUrls), parent, InstanceClassLoader.initNativeLibDirList(narNativeLibDirs, additionalResourceUrls), identifier);
        this.identifier = identifier;
        this.instanceType = type;
        this.instanceUrls = instanceUrls == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<URL>(instanceUrls));
        this.additionalResourceUrls = additionalResourceUrls == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<URL>(additionalResourceUrls));
    }

    public void close() throws IOException {
        super.close();
        ClassLoader parent = this.getParent();
        if (parent instanceof SharedInstanceClassLoader) {
            ((SharedInstanceClassLoader)((Object)parent)).close();
        }
    }

    public URL findResource(String name) {
        URL resourceUrl = super.findResource(name);
        if (resourceUrl == null) {
            resourceUrl = this.findResource(this.instanceUrls, name);
        }
        if (resourceUrl == null) {
            resourceUrl = this.findResource(this.additionalResourceUrls, name);
        }
        return resourceUrl;
    }

    private URL findResource(Set<URL> urls, String name) {
        if (urls == null || name == null) {
            return null;
        }
        for (URL url : urls) {
            try {
                URI uri = url.toURI();
                File file = new File(uri);
                if (!name.equals(file.getName())) continue;
                logger.debug("Found resource '" + name + "' from URL '" + url.toExternalForm() + "'");
                return url;
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static List<File> initNativeLibDirList(Set<File> narNativeLibDirs, Set<URL> additionalResourceUrls) {
        ArrayList<File> nativeLibDirList = new ArrayList<File>(narNativeLibDirs);
        HashSet<File> additionalNativeLibDirs = new HashSet<File>();
        if (additionalResourceUrls != null) {
            for (URL url : additionalResourceUrls) {
                File dir;
                File file;
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    file = new File(url.getPath());
                }
                catch (Exception e) {
                    logger.error("Couldn't convert url '" + String.valueOf(url) + "' to a file");
                    file = null;
                }
                if ((dir = InstanceClassLoader.toDir((File)file)) == null) continue;
                additionalNativeLibDirs.add(dir);
            }
        }
        nativeLibDirList.addAll(additionalNativeLibDirs);
        return nativeLibDirList;
    }

    private static URL[] combineURLs(Set<URL> instanceUrls, Set<URL> additionalResourceUrls) {
        LinkedHashSet<URL> allUrls = new LinkedHashSet<URL>();
        if (instanceUrls != null) {
            allUrls.addAll(instanceUrls);
        }
        if (additionalResourceUrls != null) {
            allUrls.addAll(additionalResourceUrls);
        }
        return allUrls.toArray(new URL[allUrls.size()]);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Set<URL> getInstanceUrls() {
        return this.instanceUrls;
    }

    public Set<URL> getAdditionalResourceUrls() {
        return this.additionalResourceUrls;
    }
}

