/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.bcrypt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.nifi.security.crypto.key.DerivedKey;
import org.apache.nifi.security.crypto.key.DerivedKeyProvider;
import org.apache.nifi.security.crypto.key.DerivedKeySpec;
import org.apache.nifi.security.crypto.key.DerivedSecretKey;
import org.apache.nifi.security.crypto.key.bcrypt.BcryptDerivedKeyParameterSpec;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;

public class BcryptDerivedKeyProvider
implements DerivedKeyProvider<BcryptDerivedKeyParameterSpec> {
    private static final Charset SERIALIZED_CHARACTER_SET = StandardCharsets.US_ASCII;
    private static final int SERIALIZED_HASH_START_INDEX = 29;
    private static final String DIGEST_ALGORITHM = "SHA-512";
    private static final String BCRYPT_VERSION = "2a";

    @Override
    public DerivedKey getDerivedKey(DerivedKeySpec<BcryptDerivedKeyParameterSpec> derivedKeySpec) {
        String serialized = this.getHashMessage(derivedKeySpec);
        byte[] hashMessage = serialized.getBytes(SERIALIZED_CHARACTER_SET);
        byte[] encodedRawHash = Arrays.copyOfRange(hashMessage, 29, hashMessage.length);
        byte[] derivedKeyBytes = this.getDerivedKeyBytes(encodedRawHash, derivedKeySpec.getDerivedKeyLength());
        return new DerivedSecretKey(derivedKeyBytes, derivedKeySpec.getAlgorithm(), serialized);
    }

    private String getHashMessage(DerivedKeySpec<BcryptDerivedKeyParameterSpec> derivedKeySpec) {
        BcryptDerivedKeyParameterSpec parameterSpec = derivedKeySpec.getParameterSpec();
        int cost = parameterSpec.getCost();
        byte[] salt = parameterSpec.getSalt();
        char[] password = derivedKeySpec.getPassword();
        return OpenBSDBCrypt.generate((String)BCRYPT_VERSION, (char[])password, (byte[])salt, (int)cost);
    }

    private byte[] getDerivedKeyBytes(byte[] hash, int derivedKeyLength) {
        MessageDigest messageDigest = this.getMessageDigest();
        byte[] digested = messageDigest.digest(hash);
        return Arrays.copyOf(digested, derivedKeyLength);
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(DIGEST_ALGORITHM, e);
        }
    }
}

