/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.bcrypt;

import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

class BcryptBase64Decoder {
    private static final String SHARED_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String BCRYPT_ALPHABET = String.format("./%s", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
    private static final String STANDARD_ALPHABET = String.format("%s+/", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
    private static final Map<Character, Character> BCRYPT_STANDARD_CHARACTERS = new LinkedHashMap<Character, Character>();
    private static final Base64.Decoder decoder = Base64.getDecoder();

    BcryptBase64Decoder() {
    }

    static byte[] decode(String encoded) {
        int encodedLength = encoded.length();
        byte[] converted = new byte[encodedLength];
        for (int i = 0; i < encodedLength; ++i) {
            char encodedCharacter = encoded.charAt(i);
            char standardCharacter = BcryptBase64Decoder.getStandardCharacter(encodedCharacter);
            converted[i] = (byte)standardCharacter;
        }
        return decoder.decode(converted);
    }

    private static char getStandardCharacter(char encodedCharacter) {
        Character standardCharacter = BCRYPT_STANDARD_CHARACTERS.get(Character.valueOf(encodedCharacter));
        if (standardCharacter == null) {
            String message = String.format("Encoded character [%c] not supported for bcrypt Base64 decoding", Character.valueOf(encodedCharacter));
            throw new IllegalArgumentException(message);
        }
        return standardCharacter.charValue();
    }

    static {
        char[] bcryptCharacters = BCRYPT_ALPHABET.toCharArray();
        char[] standardCharacters = STANDARD_ALPHABET.toCharArray();
        for (int i = 0; i < bcryptCharacters.length; ++i) {
            char bcryptCharacter = bcryptCharacters[i];
            char standardCharacter = standardCharacters[i];
            BCRYPT_STANDARD_CHARACTERS.put(Character.valueOf(bcryptCharacter), Character.valueOf(standardCharacter));
        }
    }
}

