/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.support.Plaintext;

public class VaultSignRequest {
    private final Plaintext plaintext;
    @Nullable
    private final String hashAlgorithm;
    @Nullable
    private final String signatureAlgorithm;
    private final boolean prehashed;

    private VaultSignRequest(Plaintext plaintext, @Nullable String hashAlgorithm, @Nullable String signatureAlgorithm, boolean prehashed) {
        this.plaintext = plaintext;
        this.hashAlgorithm = hashAlgorithm;
        this.signatureAlgorithm = signatureAlgorithm;
        this.prehashed = prehashed;
    }

    public static VaultSignRequestBuilder builder() {
        return new VaultSignRequestBuilder();
    }

    public static VaultSignRequest create(Plaintext input) {
        return VaultSignRequest.builder().plaintext(input).build();
    }

    public Plaintext getPlaintext() {
        return this.plaintext;
    }

    @Nullable
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Nullable
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Deprecated(since="2.4")
    @Nullable
    public String getAlgorithm() {
        return this.getSignatureAlgorithm();
    }

    public boolean isPrehashed() {
        return this.prehashed;
    }

    public static class VaultSignRequestBuilder {
        @Nullable
        private Plaintext plaintext;
        @Nullable
        private String hashAlgorithm;
        @Nullable
        private String signatureAlgorithm;
        private boolean prehashed;

        public VaultSignRequestBuilder plaintext(Plaintext input) {
            Assert.notNull((Object)input, (String)"Plaintext must not be null");
            this.plaintext = input;
            return this;
        }

        public VaultSignRequestBuilder hashAlgorithm(String hashAlgorithm) {
            Assert.hasText((String)hashAlgorithm, (String)"Hash algorithm must not be null or empty");
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public VaultSignRequestBuilder prehashed(boolean prehashed) {
            this.prehashed = prehashed;
            return this;
        }

        public VaultSignRequestBuilder signatureAlgorithm(String signatureAlgorithm) {
            Assert.hasText((String)signatureAlgorithm, (String)"Signature algorithm must not be null or empty");
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        @Deprecated(since="2.4")
        public VaultSignRequestBuilder algorithm(String algorithm) {
            return this.signatureAlgorithm(algorithm);
        }

        public VaultSignRequest build() {
            Assert.notNull((Object)this.plaintext, (String)"Plaintext input must not be null");
            return new VaultSignRequest(this.plaintext, this.hashAlgorithm, this.signatureAlgorithm, this.prehashed);
        }
    }
}

