/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.config.crypto;

import java.nio.charset.StandardCharsets;
import java.util.HexFormat;
import java.util.Objects;
import org.apache.nifi.security.crypto.key.DerivedKey;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.DerivedKeySpec;
import org.apache.nifi.security.crypto.key.StandardDerivedKeySpec;
import org.apache.nifi.security.crypto.key.scrypt.ScryptDerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.scrypt.ScryptDerivedKeyProvider;
import org.apache.nifi.toolkit.config.crypto.DerivedKeyGenerator;

public class StandardDerivedKeyGenerator
implements DerivedKeyGenerator {
    private static final String SALT = "NIFI_SCRYPT_SALT";
    private static final ScryptDerivedKeyProvider KEY_PROVIDER = new ScryptDerivedKeyProvider();
    private static final ScryptDerivedKeyParameterSpec KEY_PARAMETER_SPEC = new ScryptDerivedKeyParameterSpec(65536, 8, 1, "NIFI_SCRYPT_SALT".getBytes(StandardCharsets.UTF_8));
    private static final String KEY_ALGORITHM = "AES";
    private static final int KEY_LENGTH = 32;

    @Override
    public String getDerivedKeyEncoded(char[] password) {
        Objects.requireNonNull(password, "Password required");
        StandardDerivedKeySpec derivedKeySpec = new StandardDerivedKeySpec(password, 32, KEY_ALGORITHM, (DerivedKeyParameterSpec)KEY_PARAMETER_SPEC);
        DerivedKey derivedKey = KEY_PROVIDER.getDerivedKey((DerivedKeySpec)derivedKeySpec);
        return HexFormat.of().formatHex(derivedKey.getEncoded());
    }
}

