/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.config.command;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Supplier;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.properties.StandardSensitivePropertyProviderFactory;
import org.apache.nifi.properties.scheme.ProtectionScheme;
import org.apache.nifi.toolkit.config.command.converter.ProtectionSchemeTypeConverter;
import org.apache.nifi.toolkit.config.crypto.DerivedKeyGenerator;
import org.apache.nifi.toolkit.config.crypto.StandardDerivedKeyGenerator;
import org.apache.nifi.toolkit.config.transformer.BootstrapConfigurationFileTransformer;
import org.apache.nifi.toolkit.config.transformer.FileTransformer;
import org.apache.nifi.toolkit.config.transformer.XmlFileTransformer;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="encrypt-config", sortOptions=false, mixinStandardHelpOptions=true, usageHelpWidth=160, separator=" ", version={"Java ${java.version} (${java.vendor} ${java.vm.name} ${java.vm.version})"}, descriptionHeading="Description: ", description={"encrypt-config supports protection of sensitive values in Apache NiFi and Apache NiFi Registry", "", "  --nifiRegistry            Targets Apache NiFi Registry configuration files", ""})
public class SharedEncryptConfig {
    private static final String DEFAULT_PROTECTION_SCHEME = "AES_GCM";
    private static final String WORKING_FILE_NAME_FORMAT = "%s.%d.working";
    private static final DerivedKeyGenerator derivedKeyGenerator = new StandardDerivedKeyGenerator();
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Enable verbose logging for debugging"})
    boolean verboseModeEnabled;
    @CommandLine.Option(names={"-a", "--authorizers"}, description={"Path to file containing Authorizers [authorizers.xml] configuration that will be updated unless the output argument is provided"})
    Path authorizersPath;
    @CommandLine.Option(names={"-u", "--outputAuthorizers"}, description={"Path to output file for Authorizers [authorizers.xml] with property protection applied"})
    Path outputAuthorizersPath;
    @CommandLine.Option(names={"-b", "--bootstrapConf"}, description={"Path to file containing Bootstrap Configuration [bootstrap.conf] for optional root key and property protection scheme settings"})
    Path bootstrapConfPath;
    @CommandLine.Option(names={"-B", "--outputBootstrapConf"}, description={"Path to output file for Bootstrap Configuration [bootstrap.conf] with root key configured"})
    Path outputBootstrapConf;
    @CommandLine.Option(names={"-S", "--protectionScheme"}, description={"Protection Scheme for values stored in Application Properties and other configuration files. Default is ${DEFAULT-VALUE}"}, defaultValue="AES_GCM", converter={ProtectionSchemeTypeConverter.class})
    ProtectionScheme protectionScheme;
    @CommandLine.Option(names={"-H", "--oldProtectionScheme"}, description={"Previous Protection Scheme for values stored in Application Properties required for migration processing. Default is ${DEFAULT-VALUE}"}, defaultValue="AES_GCM", converter={ProtectionSchemeTypeConverter.class})
    ProtectionScheme oldProtectionScheme;
    @CommandLine.Option(names={"-k", "--key"}, description={"Bootstrap hexadecimal root key for encrypting property values in Application Properties and other configuration files"}, arity="0..1", interactive=true)
    String key;
    @CommandLine.Option(names={"-e", "--oldKey"}, description={"Previous Bootstrap hexadecimal root key used during migration for encrypting property values in Application Properties"}, arity="0..1", interactive=true)
    String oldKey;
    @CommandLine.Option(names={"-p", "--password"}, description={"Bootstrap password from which to derive the root key used to encrypt the sensitive properties in Application Properties"}, arity="0..1", interactive=true)
    String password;
    @CommandLine.Option(names={"-w", "--oldPassword"}, description={"Previous Bootstrap password from which to derive the root key during migration for decrypting sensitive properties in Application Properties"}, arity="0..1", interactive=true)
    String oldPassword;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected void processBootstrapConf(String rootKeyProperty) {
        if (this.bootstrapConfPath == null) {
            if (this.verboseModeEnabled) {
                this.logger.info("Bootstrap Configuration [bootstrap.conf] not specified");
            }
        } else {
            String rootKey = this.getRootKey();
            if (rootKey == null) {
                this.logger.info("Bootstrap Root Key or Root Password not specified");
            } else {
                this.logger.info("Started processing Bootstrap Configuration [{}]", (Object)this.bootstrapConfPath);
                BootstrapConfigurationFileTransformer fileTransformer = new BootstrapConfigurationFileTransformer(rootKeyProperty, rootKey);
                this.runFileTransformer(fileTransformer, this.bootstrapConfPath, this.outputBootstrapConf);
                this.logger.info("Completed processing Bootstrap Configuration [{}]", (Object)this.bootstrapConfPath);
            }
        }
    }

    protected void processAuthorizers() {
        if (this.authorizersPath == null) {
            if (this.verboseModeEnabled) {
                this.logger.info("Authorizers not specified");
            }
        } else {
            this.logger.info("Started processing Authorizers [{}]", (Object)this.authorizersPath);
            SensitivePropertyProvider inputSensitivePropertyProvider = this.getInputSensitivePropertyProvider();
            SensitivePropertyProviderFactory sensitivePropertyProviderFactory = this.getSensitivePropertyProviderFactory();
            XmlFileTransformer fileTransformer = new XmlFileTransformer(inputSensitivePropertyProvider, sensitivePropertyProviderFactory, this.protectionScheme);
            this.runFileTransformer(fileTransformer, this.authorizersPath, this.outputAuthorizersPath);
            this.logger.info("Completed processing Authorizers [{}]", (Object)this.authorizersPath);
        }
    }

    protected void runFileTransformer(FileTransformer fileTransformer, Path inputPath, Path outputPath) {
        Path configuredOutputPath = outputPath == null ? inputPath : outputPath;
        Path workingPath = this.getWorkingPath(configuredOutputPath);
        try {
            fileTransformer.transform(inputPath, workingPath);
            Files.move(workingPath, configuredOutputPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            String message = String.format("Processing Configuration [%s] failed", inputPath);
            throw new UncheckedIOException(message, e);
        }
    }

    protected SensitivePropertyProviderFactory getSensitivePropertyProviderFactory() {
        return StandardSensitivePropertyProviderFactory.withKeyAndBootstrapSupplier((String)this.getRootKey(), this.getBootstrapPropertiesSupplier());
    }

    protected SensitivePropertyProvider getInputSensitivePropertyProvider() {
        SensitivePropertyProvider inputSensitivePropertyProvider;
        if (this.oldPassword == null && this.oldKey == null) {
            SensitivePropertyProviderFactory sensitivePropertyProviderFactory = this.getSensitivePropertyProviderFactory();
            inputSensitivePropertyProvider = sensitivePropertyProviderFactory.getProvider(this.protectionScheme);
        } else {
            SensitivePropertyProviderFactory sensitivePropertyProviderFactory = this.getInputSensitivePropertyProviderFactory();
            inputSensitivePropertyProvider = sensitivePropertyProviderFactory.getProvider(this.oldProtectionScheme);
        }
        return inputSensitivePropertyProvider;
    }

    protected String getRootKey() {
        String rootKey;
        if (this.key == null) {
            if (this.password == null) {
                if (this.verboseModeEnabled) {
                    this.logger.info("Neither Bootstrap Root Key nor Bootstrap Password specified");
                }
                rootKey = null;
            } else {
                if (this.verboseModeEnabled) {
                    this.logger.info("Bootstrap Root Key Derivation started");
                }
                rootKey = derivedKeyGenerator.getDerivedKeyEncoded(this.password.toCharArray());
            }
        } else {
            rootKey = this.key;
        }
        return rootKey;
    }

    protected String getInputRootKey() {
        String rootKey;
        if (this.oldKey == null) {
            if (this.oldPassword == null) {
                this.logger.info("Neither Migration Bootstrap Root Key nor Migration Bootstrap Password specified");
                rootKey = null;
            } else {
                if (this.verboseModeEnabled) {
                    this.logger.info("Migration Bootstrap Root Key Derivation started");
                }
                rootKey = derivedKeyGenerator.getDerivedKeyEncoded(this.oldPassword.toCharArray());
            }
        } else {
            rootKey = this.oldKey;
        }
        return rootKey;
    }

    private Path getWorkingPath(Path resourcePath) {
        Path fileName = resourcePath.getFileName();
        String workingFileName = String.format(WORKING_FILE_NAME_FORMAT, fileName, System.currentTimeMillis());
        return resourcePath.resolveSibling(workingFileName);
    }

    private SensitivePropertyProviderFactory getInputSensitivePropertyProviderFactory() {
        return StandardSensitivePropertyProviderFactory.withKeyAndBootstrapSupplier((String)this.getInputRootKey(), this.getBootstrapPropertiesSupplier());
    }

    private Supplier<BootstrapProperties> getBootstrapPropertiesSupplier() {
        return () -> {
            if (this.bootstrapConfPath == null) {
                return BootstrapProperties.EMPTY;
            }
            try {
                return NiFiBootstrapUtils.loadBootstrapProperties((String)this.bootstrapConfPath.toString());
            }
            catch (IOException e) {
                this.logger.warn("Loading Bootstrap Configuration failed [{}]", (Object)this.bootstrapConfPath, (Object)e);
                return BootstrapProperties.EMPTY;
            }
        };
    }
}

