/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;

public interface ComponentLog {
    public void warn(String var1, Throwable var2);

    public void warn(String var1, Object ... var2);

    public void warn(String var1);

    default public void warn(LogMessage logMessage) {
        this.log(LogLevel.WARN, logMessage);
    }

    public void trace(String var1, Throwable var2);

    public void trace(String var1, Object ... var2);

    public void trace(String var1);

    default public void trace(LogMessage logMessage) {
        this.log(LogLevel.TRACE, logMessage);
    }

    public boolean isWarnEnabled();

    public boolean isTraceEnabled();

    public boolean isInfoEnabled();

    public boolean isErrorEnabled();

    public boolean isDebugEnabled();

    public void info(String var1, Throwable var2);

    public void info(String var1, Object ... var2);

    public void info(String var1);

    default public void info(LogMessage logMessage) {
        this.log(LogLevel.INFO, logMessage);
    }

    public String getName();

    public void error(String var1, Throwable var2);

    public void error(String var1, Object ... var2);

    public void error(String var1);

    default public void error(LogMessage logMessage) {
        this.log(LogLevel.ERROR, logMessage);
    }

    public void debug(String var1, Throwable var2);

    public void debug(String var1, Object ... var2);

    public void debug(String var1);

    default public void debug(LogMessage logMessage) {
        this.log(LogLevel.ERROR, logMessage);
    }

    default public void log(LogLevel level, String msg, Throwable t) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, t);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, t);
                break;
            }
            case INFO: {
                this.info(msg, t);
                break;
            }
            case TRACE: {
                this.trace(msg, t);
                break;
            }
            case WARN: {
                this.warn(msg, t);
            }
        }
    }

    default public void log(LogLevel level, String msg, Object ... os) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, os);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, os);
                break;
            }
            case INFO: {
                this.info(msg, os);
                break;
            }
            case TRACE: {
                this.trace(msg, os);
                break;
            }
            case WARN: {
                this.warn(msg, os);
            }
        }
    }

    default public void log(LogLevel level, String msg) {
        switch (level) {
            case DEBUG: {
                this.debug(msg);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg);
                break;
            }
            case INFO: {
                this.info(msg);
                break;
            }
            case TRACE: {
                this.trace(msg);
                break;
            }
            case WARN: {
                this.warn(msg);
            }
        }
    }

    default public void log(LogMessage message) {
        switch (message.getLogLevel()) {
            case DEBUG: {
                this.debug(message);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(message);
                break;
            }
            case INFO: {
                this.info(message);
                break;
            }
            case TRACE: {
                this.trace(message);
                break;
            }
            case WARN: {
                this.warn(message);
            }
        }
    }

    default public void log(LogLevel level, LogMessage logMessage) {
        String msg = logMessage.getMessage();
        Throwable t = logMessage.getThrowable();
        Object[] os = logMessage.getObjects();
        if (os != null && t != null) {
            Object[] ost = new Object[os.length + 1];
            System.arraycopy(os, 0, ost, 0, os.length);
            ost[ost.length - 1] = t;
            this.log(level, msg, ost);
        } else if (os != null) {
            this.log(level, msg, os);
        } else if (t != null) {
            this.log(level, msg, t);
        } else {
            this.log(level, msg);
        }
    }
}

