/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.database;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.security.authorization.AbstractConfigurableAccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.AccessPolicy;
import org.apache.nifi.registry.security.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.annotation.AuthorizerContext;
import org.apache.nifi.registry.security.authorization.database.entity.DatabaseAccessPolicy;
import org.apache.nifi.registry.security.authorization.database.mapper.DatabaseAccessPolicyRowMapper;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.registry.security.authorization.util.AccessPolicyProviderUtils;
import org.apache.nifi.registry.security.authorization.util.InitialPolicies;
import org.apache.nifi.registry.security.authorization.util.ResourceAndAction;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class DatabaseAccessPolicyProvider
extends AbstractConfigurableAccessPolicyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseAccessPolicyProvider.class);
    private DataSource dataSource;
    private IdentityMapper identityMapper;
    private JdbcTemplate jdbcTemplate;

    @AuthorizerContext
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @AuthorizerContext
    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    @Override
    protected void doInitialize(AccessPolicyProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
        super.doInitialize(initializationContext);
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
    }

    @Override
    public void doOnConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        String initialAdminIdentity = AccessPolicyProviderUtils.getInitialAdminIdentity(configurationContext, this.identityMapper);
        Set<String> nifiIdentities = AccessPolicyProviderUtils.getNiFiIdentities(configurationContext, this.identityMapper);
        String nifiGroupName = AccessPolicyProviderUtils.getNiFiGroupName(configurationContext, this.identityMapper);
        if (!StringUtils.isBlank((CharSequence)initialAdminIdentity)) {
            LOGGER.info("Populating authorizations for Initial Admin: '" + initialAdminIdentity + "'");
            this.populateInitialAdmin(initialAdminIdentity);
        }
        if (!CollectionUtils.isEmpty(nifiIdentities)) {
            LOGGER.info("Populating authorizations for NiFi identities: [{}]", (Object)StringUtils.join(nifiIdentities, (String)";"));
            this.populateNiFiIdentities(nifiIdentities);
        }
        if (!StringUtils.isBlank((CharSequence)nifiGroupName)) {
            LOGGER.info("Populating authorizations for NiFi Group: '" + nifiGroupName + "'");
            this.populateNiFiGroup(nifiGroupName);
        }
    }

    private void populateInitialAdmin(String initialAdminIdentity) {
        User initialAdmin = this.getUserGroupProvider().getUserByIdentity(initialAdminIdentity);
        if (initialAdmin == null) {
            throw new SecurityProviderCreationException("Unable to locate initial admin '" + initialAdminIdentity + "' to seed policies");
        }
        for (ResourceAndAction resourceAction : InitialPolicies.ADMIN_POLICIES) {
            this.populateInitialPolicy(initialAdmin, resourceAction);
        }
    }

    private void populateNiFiIdentities(Set<String> nifiIdentities) {
        for (String nifiIdentity : nifiIdentities) {
            User nifiUser = this.getUserGroupProvider().getUserByIdentity(nifiIdentity);
            if (nifiUser == null) {
                throw new SecurityProviderCreationException("Unable to locate NiFi identity '" + nifiIdentity + "' to seed policies.");
            }
            for (ResourceAndAction resourceAction : InitialPolicies.NIFI_POLICIES) {
                this.populateInitialPolicy(nifiUser, resourceAction);
            }
        }
    }

    private void populateNiFiGroup(String nifiGroupName) {
        Group nifiGroup = AccessPolicyProviderUtils.getGroup(nifiGroupName, this.getUserGroupProvider());
        for (ResourceAndAction resourceAction : InitialPolicies.NIFI_POLICIES) {
            this.populateInitialPolicy(nifiGroup, resourceAction);
        }
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }

    public String getFingerprint() throws AuthorizationAccessException {
        throw new UnsupportedOperationException("Fingerprinting is not supported by this provider");
    }

    public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        throw new UnsupportedOperationException("Fingerprinting is not supported by this provider");
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        throw new UnsupportedOperationException("Fingerprinting is not supported by this provider");
    }

    public AccessPolicy addAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        Objects.requireNonNull(accessPolicy);
        String policySql = "INSERT INTO APP_POLICY(IDENTIFIER, RESOURCE, ACTION) VALUES (?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO APP_POLICY(IDENTIFIER, RESOURCE, ACTION) VALUES (?, ?, ?)", new Object[]{accessPolicy.getIdentifier(), accessPolicy.getResource(), accessPolicy.getAction().toString()});
        this.createPolicyUserAndGroups(accessPolicy);
        return accessPolicy;
    }

    public AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        Objects.requireNonNull(accessPolicy);
        DatabaseAccessPolicy existingPolicy = this.getDatabaseAcessPolicy(accessPolicy.getIdentifier());
        if (existingPolicy == null) {
            return null;
        }
        String deletePolicyUsersSql = "DELETE FROM APP_POLICY_USER WHERE POLICY_IDENTIFIER = ?";
        this.jdbcTemplate.update("DELETE FROM APP_POLICY_USER WHERE POLICY_IDENTIFIER = ?", new Object[]{accessPolicy.getIdentifier()});
        String deletePolicyGroupsSql = "DELETE FROM APP_POLICY_GROUP WHERE POLICY_IDENTIFIER = ?";
        this.jdbcTemplate.update("DELETE FROM APP_POLICY_GROUP WHERE POLICY_IDENTIFIER = ?", new Object[]{accessPolicy.getIdentifier()});
        this.createPolicyUserAndGroups(accessPolicy);
        return accessPolicy;
    }

    public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
        String sql = "SELECT * FROM APP_POLICY";
        List databasePolicies = this.jdbcTemplate.query("SELECT * FROM APP_POLICY", (RowMapper)new DatabaseAccessPolicyRowMapper());
        HashMap policyToUsers = new HashMap();
        this.jdbcTemplate.query("SELECT * FROM APP_POLICY_USER", rs -> {
            String policyIdentifier = rs.getString("POLICY_IDENTIFIER");
            String userIdentifier = rs.getString("USER_IDENTIFIER");
            Set userIdentifiers = policyToUsers.computeIfAbsent(policyIdentifier, k -> new HashSet());
            userIdentifiers.add(userIdentifier);
        });
        HashMap policyToGroups = new HashMap();
        this.jdbcTemplate.query("SELECT * FROM APP_POLICY_GROUP", rs -> {
            String policyIdentifier = rs.getString("POLICY_IDENTIFIER");
            String groupIdentifier = rs.getString("GROUP_IDENTIFIER");
            Set groupIdentifiers = policyToGroups.computeIfAbsent(policyIdentifier, k -> new HashSet());
            groupIdentifiers.add(groupIdentifier);
        });
        HashSet<AccessPolicy> policies = new HashSet<AccessPolicy>();
        databasePolicies.forEach(p -> {
            Set userIdentifiers = (Set)policyToUsers.get(p.getIdentifier());
            Set groupIdentifiers = (Set)policyToGroups.get(p.getIdentifier());
            policies.add(this.mapTopAccessPolicy((DatabaseAccessPolicy)p, userIdentifiers, groupIdentifiers));
        });
        return policies;
    }

    public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
        Validate.notBlank((CharSequence)identifier);
        DatabaseAccessPolicy databaseAccessPolicy = this.getDatabaseAcessPolicy(identifier);
        if (databaseAccessPolicy == null) {
            return null;
        }
        Set<String> userIdentifiers = this.getPolicyUsers(identifier);
        Set<String> groupIdentifiers = this.getPolicyGroups(identifier);
        return this.mapTopAccessPolicy(databaseAccessPolicy, userIdentifiers, groupIdentifiers);
    }

    public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
        Validate.notBlank((CharSequence)resourceIdentifier);
        Objects.requireNonNull(action);
        String policySql = "SELECT * FROM APP_POLICY WHERE RESOURCE = ? AND ACTION = ?";
        Object[] args = new Object[]{resourceIdentifier, action.toString()};
        DatabaseAccessPolicy databaseAccessPolicy = this.queryForObject("SELECT * FROM APP_POLICY WHERE RESOURCE = ? AND ACTION = ?", new DatabaseAccessPolicyRowMapper(), args);
        if (databaseAccessPolicy == null) {
            return null;
        }
        Set<String> userIdentifiers = this.getPolicyUsers(databaseAccessPolicy.getIdentifier());
        Set<String> groupIdentifiers = this.getPolicyGroups(databaseAccessPolicy.getIdentifier());
        return this.mapTopAccessPolicy(databaseAccessPolicy, userIdentifiers, groupIdentifiers);
    }

    public AccessPolicy deleteAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        Objects.requireNonNull(accessPolicy);
        String sql = "DELETE FROM APP_POLICY WHERE IDENTIFIER = ?";
        int rowsUpdated = this.jdbcTemplate.update("DELETE FROM APP_POLICY WHERE IDENTIFIER = ?", new Object[]{accessPolicy.getIdentifier()});
        if (rowsUpdated <= 0) {
            return null;
        }
        return accessPolicy;
    }

    protected void createPolicyUserAndGroups(AccessPolicy accessPolicy) {
        if (accessPolicy.getUsers() != null) {
            for (String userIdentifier : accessPolicy.getUsers()) {
                this.insertPolicyUser(accessPolicy.getIdentifier(), userIdentifier);
            }
        }
        if (accessPolicy.getGroups() != null) {
            for (String groupIdentifier : accessPolicy.getGroups()) {
                this.insertPolicyGroup(accessPolicy.getIdentifier(), groupIdentifier);
            }
        }
    }

    protected void insertPolicyGroup(String policyIdentifier, String groupIdentifier) {
        String policyGroupSql = "INSERT INTO APP_POLICY_GROUP(POLICY_IDENTIFIER, GROUP_IDENTIFIER) VALUES (?, ?)";
        this.jdbcTemplate.update("INSERT INTO APP_POLICY_GROUP(POLICY_IDENTIFIER, GROUP_IDENTIFIER) VALUES (?, ?)", new Object[]{policyIdentifier, groupIdentifier});
    }

    protected void insertPolicyUser(String policyIdentifier, String userIdentifier) {
        String policyUserSql = "INSERT INTO APP_POLICY_USER(POLICY_IDENTIFIER, USER_IDENTIFIER) VALUES (?, ?)";
        this.jdbcTemplate.update("INSERT INTO APP_POLICY_USER(POLICY_IDENTIFIER, USER_IDENTIFIER) VALUES (?, ?)", new Object[]{policyIdentifier, userIdentifier});
    }

    protected DatabaseAccessPolicy getDatabaseAcessPolicy(String policyIdentifier) {
        String sql = "SELECT * FROM APP_POLICY WHERE IDENTIFIER = ?";
        return this.queryForObject("SELECT * FROM APP_POLICY WHERE IDENTIFIER = ?", new DatabaseAccessPolicyRowMapper(), policyIdentifier);
    }

    protected Set<String> getPolicyUsers(String policyIdentifier) {
        String sql = "SELECT * FROM APP_POLICY_USER WHERE POLICY_IDENTIFIER = ?";
        HashSet<String> userIdentifiers = new HashSet<String>();
        this.jdbcTemplate.query("SELECT * FROM APP_POLICY_USER WHERE POLICY_IDENTIFIER = ?", rs -> userIdentifiers.add(rs.getString("USER_IDENTIFIER")), new Object[]{policyIdentifier});
        return userIdentifiers;
    }

    protected Set<String> getPolicyGroups(String policyIdentifier) {
        String sql = "SELECT * FROM APP_POLICY_GROUP WHERE POLICY_IDENTIFIER = ?";
        HashSet<String> groupIdentifiers = new HashSet<String>();
        this.jdbcTemplate.query("SELECT * FROM APP_POLICY_GROUP WHERE POLICY_IDENTIFIER = ?", rs -> groupIdentifiers.add(rs.getString("GROUP_IDENTIFIER")), new Object[]{policyIdentifier});
        return groupIdentifiers;
    }

    protected AccessPolicy mapTopAccessPolicy(DatabaseAccessPolicy databaseAccessPolicy, Set<String> userIdentifiers, Set<String> groupIdentifiers) {
        return new AccessPolicy.Builder().identifier(databaseAccessPolicy.getIdentifier()).resource(databaseAccessPolicy.getResource()).action(RequestAction.valueOfValue((String)databaseAccessPolicy.getAction())).addUsers(userIdentifiers).addGroups(groupIdentifiers).build();
    }

    protected void populateInitialPolicy(User initialUser, ResourceAndAction resourceAndAction) {
        RequestAction action;
        String userIdentifier = initialUser.getIdentifier();
        String resourceIdentifier = resourceAndAction.getResource().getIdentifier();
        AccessPolicy existingPolicy = this.getAccessPolicy(resourceIdentifier, action = resourceAndAction.getAction());
        if (existingPolicy == null) {
            AccessPolicy accessPolicy = new AccessPolicy.Builder().identifierGenerateRandom().resource(resourceIdentifier).action(action).addUser(userIdentifier).build();
            this.addAccessPolicy(accessPolicy);
        } else if (existingPolicy.getUsers().contains(initialUser.getIdentifier())) {
            LOGGER.debug("'{}' is already part of the policy for {} {}", new Object[]{initialUser.getIdentity(), action.toString(), resourceIdentifier});
        } else {
            LOGGER.debug("Adding '{}' to the policy for {} {}", new Object[]{initialUser.getIdentity(), action.toString(), resourceIdentifier});
            this.insertPolicyUser(existingPolicy.getIdentifier(), userIdentifier);
        }
    }

    protected void populateInitialPolicy(Group initialGroup, ResourceAndAction resourceAndAction) {
        RequestAction action;
        String resourceIdentifier = resourceAndAction.getResource().getIdentifier();
        AccessPolicy existingPolicy = this.getAccessPolicy(resourceIdentifier, action = resourceAndAction.getAction());
        if (existingPolicy == null) {
            AccessPolicy accessPolicy = new AccessPolicy.Builder().identifierGenerateRandom().resource(resourceIdentifier).action(action).addGroup(initialGroup.getIdentifier()).build();
            this.addAccessPolicy(accessPolicy);
        } else {
            this.insertPolicyGroup(existingPolicy.getIdentifier(), initialGroup.getIdentifier());
        }
    }

    protected <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) {
        try {
            return (T)this.jdbcTemplate.queryForObject(sql, rowMapper, args);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}

