/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.properties.scheme.ProtectionScheme;
import org.apache.nifi.properties.scheme.StandardProtectionScheme;
import org.apache.nifi.registry.extension.ExtensionClassLoader;
import org.apache.nifi.registry.extension.ExtensionCloseable;
import org.apache.nifi.registry.extension.ExtensionManager;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.security.authorization.AccessPolicy;
import org.apache.nifi.registry.security.authorization.AccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.AccessPolicyProviderLookup;
import org.apache.nifi.registry.security.authorization.AuthorizationAuditor;
import org.apache.nifi.registry.security.authorization.AuthorizationRequest;
import org.apache.nifi.registry.security.authorization.AuthorizationResult;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.AuthorizerFactoryException;
import org.apache.nifi.registry.security.authorization.AuthorizerInitializationContext;
import org.apache.nifi.registry.security.authorization.AuthorizerLookup;
import org.apache.nifi.registry.security.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.ManagedAuthorizer;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.StandardAuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.StandardAuthorizerInitializationContext;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.UserGroupProviderLookup;
import org.apache.nifi.registry.security.authorization.annotation.AuthorizerContext;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.registry.security.authorization.generated.Authorizer;
import org.apache.nifi.registry.security.authorization.generated.Authorizers;
import org.apache.nifi.registry.security.authorization.generated.Prop;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.apache.nifi.registry.security.util.ClassLoaderUtils;
import org.apache.nifi.registry.service.RegistryService;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Configuration(value="authorizerFactory")
public class AuthorizerFactory
implements UserGroupProviderLookup,
AccessPolicyProviderLookup,
AuthorizerLookup,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizerFactory.class);
    private static final String AUTHORIZERS_XSD = "/authorizers.xsd";
    private static final String JAXB_GENERATED_PATH = "org.apache.nifi.registry.security.authorization.generated";
    private static final JAXBContext JAXB_CONTEXT = AuthorizerFactory.initializeJaxbContext();
    private final NiFiRegistryProperties properties;
    private final ExtensionManager extensionManager;
    private final SensitivePropertyProviderFactory sensitivePropertyProviderFactory;
    private final RegistryService registryService;
    private final DataSource dataSource;
    private final IdentityMapper identityMapper;
    private org.apache.nifi.registry.security.authorization.Authorizer authorizer;
    private final Map<String, UserGroupProvider> userGroupProviders = new HashMap<String, UserGroupProvider>();
    private final Map<String, AccessPolicyProvider> accessPolicyProviders = new HashMap<String, AccessPolicyProvider>();
    private final Map<String, org.apache.nifi.registry.security.authorization.Authorizer> authorizers = new HashMap<String, org.apache.nifi.registry.security.authorization.Authorizer>();

    private static JAXBContext initializeJaxbContext() {
        try {
            return JAXBContext.newInstance((String)JAXB_GENERATED_PATH, (ClassLoader)AuthorizerFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.", e);
        }
    }

    @Autowired
    public AuthorizerFactory(NiFiRegistryProperties properties, ExtensionManager extensionManager, @Nullable SensitivePropertyProviderFactory sensitivePropertyProviderFactory, RegistryService registryService, DataSource dataSource, IdentityMapper identityMapper) {
        this.properties = Objects.requireNonNull(properties);
        this.extensionManager = Objects.requireNonNull(extensionManager);
        this.sensitivePropertyProviderFactory = sensitivePropertyProviderFactory;
        this.registryService = Objects.requireNonNull(registryService);
        this.dataSource = Objects.requireNonNull(dataSource);
        this.identityMapper = Objects.requireNonNull(identityMapper);
    }

    public UserGroupProvider getUserGroupProvider(String identifier) {
        return this.userGroupProviders.get(identifier);
    }

    public AccessPolicyProvider getAccessPolicyProvider(String identifier) {
        return this.accessPolicyProviders.get(identifier);
    }

    public org.apache.nifi.registry.security.authorization.Authorizer getAuthorizer(String identifier) {
        return this.authorizers.get(identifier);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public org.apache.nifi.registry.security.authorization.Authorizer getAuthorizer() throws AuthorizerFactoryException {
        if (this.authorizer == null) {
            if (this.properties.getSslPort() == null) {
                this.authorizer = this.createDefaultAuthorizer();
            } else {
                String authorizerIdentifier = this.properties.getProperty("nifi.registry.security.authorizer");
                if (StringUtils.isBlank((CharSequence)authorizerIdentifier)) {
                    throw new AuthorizerFactoryException("When running securely, the authorizer identifier must be specified in the nifi-registry.properties file.");
                }
                try {
                    void var4_19;
                    ExtensionCloseable extClosable;
                    ClassLoader instanceClassLoader;
                    Object instance;
                    Authorizers authorizerConfiguration = this.loadAuthorizersConfiguration();
                    for (org.apache.nifi.registry.security.authorization.generated.UserGroupProvider userGroupProvider : authorizerConfiguration.getUserGroupProvider()) {
                        if (this.userGroupProviders.containsKey(userGroupProvider.getIdentifier())) {
                            throw new AuthorizerFactoryException("Duplicate User Group Provider identifier in Authorizers configuration: " + userGroupProvider.getIdentifier());
                        }
                        this.userGroupProviders.put(userGroupProvider.getIdentifier(), this.createUserGroupProvider(userGroupProvider.getIdentifier(), userGroupProvider.getClazz()));
                    }
                    for (org.apache.nifi.registry.security.authorization.generated.UserGroupProvider userGroupProvider : authorizerConfiguration.getUserGroupProvider()) {
                        instance = this.userGroupProviders.get(userGroupProvider.getIdentifier());
                        instanceClassLoader = instance.getClass().getClassLoader();
                        extClosable = ExtensionCloseable.withClassLoader(instanceClassLoader);
                        try {
                            instance.onConfigured(this.loadAuthorizerConfiguration(userGroupProvider.getIdentifier(), userGroupProvider.getProperty()));
                        }
                        finally {
                            if (extClosable == null) continue;
                            extClosable.close();
                        }
                    }
                    for (org.apache.nifi.registry.security.authorization.generated.AccessPolicyProvider accessPolicyProvider : authorizerConfiguration.getAccessPolicyProvider()) {
                        if (this.accessPolicyProviders.containsKey(accessPolicyProvider.getIdentifier())) {
                            throw new AuthorizerFactoryException("Duplicate Access Policy Provider identifier in Authorizers configuration: " + accessPolicyProvider.getIdentifier());
                        }
                        this.accessPolicyProviders.put(accessPolicyProvider.getIdentifier(), this.createAccessPolicyProvider(accessPolicyProvider.getIdentifier(), accessPolicyProvider.getClazz()));
                    }
                    for (org.apache.nifi.registry.security.authorization.generated.AccessPolicyProvider accessPolicyProvider : authorizerConfiguration.getAccessPolicyProvider()) {
                        instance = this.accessPolicyProviders.get(accessPolicyProvider.getIdentifier());
                        instanceClassLoader = instance.getClass().getClassLoader();
                        extClosable = ExtensionCloseable.withClassLoader(instanceClassLoader);
                        try {
                            instance.onConfigured(this.loadAuthorizerConfiguration(accessPolicyProvider.getIdentifier(), accessPolicyProvider.getProperty()));
                        }
                        finally {
                            if (extClosable == null) continue;
                            extClosable.close();
                        }
                    }
                    for (Authorizer authorizer : authorizerConfiguration.getAuthorizer()) {
                        if (this.authorizers.containsKey(authorizer.getIdentifier())) {
                            throw new AuthorizerFactoryException("Duplicate Authorizer identifier in Authorizers configuration: " + authorizer.getIdentifier());
                        }
                        this.authorizers.put(authorizer.getIdentifier(), this.createAuthorizer(authorizer.getIdentifier(), authorizer.getClazz(), authorizer.getClasspath()));
                    }
                    for (Authorizer authorizer : authorizerConfiguration.getAuthorizer()) {
                        if (authorizer.getIdentifier().equals(authorizerIdentifier)) continue;
                        instance = this.authorizers.get(authorizer.getIdentifier());
                        instanceClassLoader = instance.getClass().getClassLoader();
                        extClosable = ExtensionCloseable.withClassLoader(instanceClassLoader);
                        try {
                            instance.onConfigured(this.loadAuthorizerConfiguration(authorizer.getIdentifier(), authorizer.getProperty()));
                        }
                        finally {
                            if (extClosable == null) continue;
                            extClosable.close();
                        }
                    }
                    this.authorizer = this.getAuthorizer(authorizerIdentifier);
                    if (this.authorizer == null) {
                        throw new AuthorizerFactoryException(String.format("The specified authorizer '%s' could not be found.", authorizerIdentifier));
                    }
                    ClassLoader authorizerClassLoader = this.authorizer.getClass().getClassLoader();
                    this.authorizer = AuthorizerFactory.installIntegrityChecks(this.authorizer);
                    Object var4_17 = null;
                    for (Authorizer provider : authorizerConfiguration.getAuthorizer()) {
                        if (!provider.getIdentifier().equals(authorizerIdentifier)) continue;
                        AuthorizerConfigurationContext authorizerConfigurationContext = this.loadAuthorizerConfiguration(provider.getIdentifier(), provider.getProperty());
                        break;
                    }
                    if (var4_19 == null) {
                        throw new IllegalStateException("Unable to load configuration for authorizer with id: " + authorizerIdentifier);
                    }
                    try (ExtensionCloseable extClosable2 = ExtensionCloseable.withClassLoader(authorizerClassLoader);){
                        this.authorizer.onConfigured((AuthorizerConfigurationContext)var4_19);
                    }
                }
                catch (AuthorizerFactoryException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new AuthorizerFactoryException("Failed to construct Authorizer.", e);
                }
            }
        }
        return this.authorizer;
    }

    public void destroy() throws Exception {
        if (this.authorizers != null) {
            this.authorizers.forEach((key, value) -> value.preDestruction());
        }
        if (this.accessPolicyProviders != null) {
            this.accessPolicyProviders.forEach((key, value) -> value.preDestruction());
        }
        if (this.userGroupProviders != null) {
            this.userGroupProviders.forEach((key, value) -> value.preDestruction());
        }
    }

    private Authorizers loadAuthorizersConfiguration() throws Exception {
        File authorizersConfigurationFile = this.properties.getAuthorizersConfigurationFile();
        if (authorizersConfigurationFile.exists()) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(Authorizers.class.getResource(AUTHORIZERS_XSD));
                Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
                unmarshaller.setSchema(schema);
                StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
                XMLStreamReader reader = provider.getStreamReader(new StreamSource(authorizersConfigurationFile));
                JAXBElement element = unmarshaller.unmarshal(reader, Authorizers.class);
                return (Authorizers)element.getValue();
            }
            catch (JAXBException | ProcessingException e) {
                throw new Exception("Unable to load the authorizer configuration file at: " + authorizersConfigurationFile.getAbsolutePath(), e);
            }
        }
        throw new Exception("Unable to find the authorizer configuration file at " + authorizersConfigurationFile.getAbsolutePath());
    }

    private AuthorizerConfigurationContext loadAuthorizerConfiguration(String identifier, List<Prop> properties) {
        HashMap<String, String> authorizerProperties = new HashMap<String, String>();
        for (Prop property : properties) {
            if (!StringUtils.isBlank((CharSequence)property.getEncryption())) {
                String decryptedValue = this.decryptValue(property.getValue(), property.getEncryption(), property.getName(), identifier);
                authorizerProperties.put(property.getName(), decryptedValue);
                continue;
            }
            authorizerProperties.put(property.getName(), property.getValue());
        }
        return new StandardAuthorizerConfigurationContext(identifier, authorizerProperties);
    }

    private UserGroupProvider createUserGroupProvider(String identifier, String userGroupProviderClassName) throws Exception {
        UserGroupProvider instance;
        ExtensionClassLoader classLoader = this.extensionManager.getExtensionClassLoader(userGroupProviderClassName);
        if (classLoader == null) {
            throw new IllegalStateException("Extension not found in any of the configured class loaders: " + userGroupProviderClassName);
        }
        try (ExtensionCloseable closeable = ExtensionCloseable.withClassLoader(classLoader);){
            Class<?> rawUserGroupProviderClass = Class.forName(userGroupProviderClassName, true, classLoader);
            Class<UserGroupProvider> userGroupProviderClass = rawUserGroupProviderClass.asSubclass(UserGroupProvider.class);
            Constructor<UserGroupProvider> constructor = userGroupProviderClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, userGroupProviderClass);
            this.performFieldInjection(instance, userGroupProviderClass);
            instance.initialize((UserGroupProviderInitializationContext)new StandardAuthorizerInitializationContext(identifier, this, this, this));
        }
        return instance;
    }

    private AccessPolicyProvider createAccessPolicyProvider(String identifier, String accessPolicyProviderClassName) throws Exception {
        AccessPolicyProvider instance;
        ExtensionClassLoader classLoader = this.extensionManager.getExtensionClassLoader(accessPolicyProviderClassName);
        if (classLoader == null) {
            throw new IllegalStateException("Extension not found in any of the configured class loaders: " + accessPolicyProviderClassName);
        }
        try (ExtensionCloseable closeable = ExtensionCloseable.withClassLoader(classLoader);){
            Class<?> rawAccessPolicyProviderClass = Class.forName(accessPolicyProviderClassName, true, classLoader);
            Class<AccessPolicyProvider> accessPolicyClass = rawAccessPolicyProviderClass.asSubclass(AccessPolicyProvider.class);
            Constructor<AccessPolicyProvider> constructor = accessPolicyClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, accessPolicyClass);
            this.performFieldInjection(instance, accessPolicyClass);
            instance.initialize((AccessPolicyProviderInitializationContext)new StandardAuthorizerInitializationContext(identifier, this, this, this));
        }
        return instance;
    }

    private org.apache.nifi.registry.security.authorization.Authorizer createAuthorizer(String identifier, String authorizerClassName, String classpathResources) throws Exception {
        org.apache.nifi.registry.security.authorization.Authorizer instance;
        URLClassLoader classLoader;
        ExtensionClassLoader extensionClassLoader = this.extensionManager.getExtensionClassLoader(authorizerClassName);
        if (extensionClassLoader == null) {
            throw new IllegalStateException("Extension not found in any of the configured class loaders: " + authorizerClassName);
        }
        if (StringUtils.isNotEmpty((CharSequence)classpathResources)) {
            logger.info(String.format("Replacing Authorizer ClassLoader for '%s' to include additional resources: %s", identifier, classpathResources));
            URL[] originalUrls = extensionClassLoader.getURLs();
            URL[] additionalUrls = ClassLoaderUtils.getURLsForClasspath(classpathResources, null, true);
            HashSet<URL> combinedUrls = new HashSet<URL>();
            combinedUrls.addAll(Arrays.asList(originalUrls));
            combinedUrls.addAll(Arrays.asList(additionalUrls));
            URL[] urls = combinedUrls.toArray(new URL[combinedUrls.size()]);
            classLoader = new URLClassLoader(urls, extensionClassLoader.getParent());
        } else {
            classLoader = extensionClassLoader;
        }
        try (ExtensionCloseable closeable = ExtensionCloseable.withClassLoader(classLoader);){
            Class<?> rawAuthorizerClass = Class.forName(authorizerClassName, true, classLoader);
            Class<org.apache.nifi.registry.security.authorization.Authorizer> authorizerClass = rawAuthorizerClass.asSubclass(org.apache.nifi.registry.security.authorization.Authorizer.class);
            Constructor<org.apache.nifi.registry.security.authorization.Authorizer> constructor = authorizerClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, authorizerClass);
            this.performFieldInjection(instance, authorizerClass);
            instance.initialize((AuthorizerInitializationContext)new StandardAuthorizerInitializationContext(identifier, this, this, this));
        }
        return instance;
    }

    private void performMethodInjection(Object instance, Class<?> authorizerClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : authorizerClass.getMethods()) {
            if (!method.isAnnotationPresent(AuthorizerContext.class)) continue;
            method.setAccessible(true);
            Class<?>[] argumentTypes = method.getParameterTypes();
            if (argumentTypes.length != 1) continue;
            Class<?> argumentType = argumentTypes[0];
            if (NiFiRegistryProperties.class.isAssignableFrom(argumentType)) {
                method.invoke(instance, this.properties);
                continue;
            }
            if (DataSource.class.isAssignableFrom(argumentType)) {
                method.invoke(instance, this.dataSource);
                continue;
            }
            if (!IdentityMapper.class.isAssignableFrom(argumentType)) continue;
            method.invoke(instance, this.identityMapper);
        }
        Class<?> parentClass = authorizerClass.getSuperclass();
        if (parentClass != null && org.apache.nifi.registry.security.authorization.Authorizer.class.isAssignableFrom(parentClass)) {
            this.performMethodInjection(instance, parentClass);
        }
    }

    private void performFieldInjection(Object instance, Class<?> authorizerClass) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : authorizerClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(AuthorizerContext.class)) continue;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (field.get(instance) != null) continue;
            if (NiFiRegistryProperties.class.isAssignableFrom(fieldType)) {
                field.set(instance, this.properties);
                continue;
            }
            if (DataSource.class.isAssignableFrom(fieldType)) {
                field.set(instance, this.dataSource);
                continue;
            }
            if (!IdentityMapper.class.isAssignableFrom(fieldType)) continue;
            field.set(instance, this.identityMapper);
        }
        Class<?> parentClass = authorizerClass.getSuperclass();
        if (parentClass != null && org.apache.nifi.registry.security.authorization.Authorizer.class.isAssignableFrom(parentClass)) {
            this.performFieldInjection(instance, parentClass);
        }
    }

    private String decryptValue(String cipherText, String encryptionScheme, String propertyName, String groupIdentifier) throws SensitivePropertyProtectionException {
        if (this.sensitivePropertyProviderFactory == null) {
            throw new SensitivePropertyProtectionException("Sensitive Property Provider Factory dependency was never wired, so protected properties cannot be decrypted. This usually indicates that a master key for this NiFi Registry was not detected and configured during the bootstrap startup sequence. Contact the system administrator.");
        }
        try {
            SensitivePropertyProvider sensitivePropertyProvider = this.sensitivePropertyProviderFactory.getProvider((ProtectionScheme)new StandardProtectionScheme(encryptionScheme));
            return sensitivePropertyProvider.unprotect(cipherText, this.sensitivePropertyProviderFactory.getPropertyContext(groupIdentifier, propertyName));
        }
        catch (IllegalArgumentException e) {
            throw new SensitivePropertyProtectionException(String.format("Authorizer configuration XML was protected using %s, which is not supported. Cannot configure this Authorizer due to failing to decrypt protected configuration properties.", encryptionScheme));
        }
    }

    private org.apache.nifi.registry.security.authorization.Authorizer createDefaultAuthorizer() {
        return new org.apache.nifi.registry.security.authorization.Authorizer(this){

            public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
                return AuthorizationResult.approved();
            }

            public void initialize(AuthorizerInitializationContext initializationContext) throws SecurityProviderCreationException {
            }

            public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
            }

            public void preDestruction() throws SecurityProviderCreationException {
            }
        };
    }

    private static org.apache.nifi.registry.security.authorization.Authorizer installIntegrityChecks(org.apache.nifi.registry.security.authorization.Authorizer baseAuthorizer) {
        if (baseAuthorizer instanceof ManagedAuthorizer) {
            return new ManagedAuthorizerWrapper((ManagedAuthorizer)baseAuthorizer);
        }
        return new AuthorizerWrapper(baseAuthorizer);
    }

    private static void audit(org.apache.nifi.registry.security.authorization.Authorizer authorizer, AuthorizationRequest request, AuthorizationResult result) {
        if (authorizer instanceof AuthorizationAuditor && request.isAccessAttempt() && !AuthorizationResult.Result.ResourceNotFound.equals((Object)result.getResult())) {
            ((AuthorizationAuditor)authorizer).auditAccessAttempt(request, result);
        }
    }

    private static boolean policyExists(AccessPolicyProvider accessPolicyProvider, AccessPolicy checkAccessPolicy) {
        return AuthorizerFactory.policyExists(accessPolicyProvider.getAccessPolicies(), checkAccessPolicy);
    }

    private static boolean policyExists(Collection<AccessPolicy> policies, AccessPolicy checkAccessPolicy) {
        for (AccessPolicy accessPolicy : policies) {
            if (accessPolicy.getIdentifier().equals(checkAccessPolicy.getIdentifier()) || !accessPolicy.getResource().equals(checkAccessPolicy.getResource()) || !accessPolicy.getAction().equals((Object)checkAccessPolicy.getAction())) continue;
            return true;
        }
        return false;
    }

    private static boolean userExists(UserGroupProvider userGroupProvider, String identifier, String identity) {
        for (User user : userGroupProvider.getUsers()) {
            if (user.getIdentifier().equals(identifier) || !user.getIdentity().equals(identity)) continue;
            return true;
        }
        return false;
    }

    private static boolean groupExists(UserGroupProvider userGroupProvider, String identifier, String identity) {
        for (Group group : userGroupProvider.getGroups()) {
            if (group.getIdentifier().equals(identifier) || !group.getName().equals(identity)) continue;
            return true;
        }
        return false;
    }

    private static boolean allGroupUsersExist(UserGroupProvider userGroupProvider, Group group) {
        for (String userIdentifier : group.getUsers()) {
            User user = userGroupProvider.getUser(userIdentifier);
            if (user != null) continue;
            return false;
        }
        return true;
    }

    private static class ManagedAuthorizerWrapper
    implements ManagedAuthorizer,
    WrappedAuthorizer {
        private final ManagedAuthorizer baseManagedAuthorizer;

        public ManagedAuthorizerWrapper(ManagedAuthorizer baseManagedAuthorizer) {
            this.baseManagedAuthorizer = baseManagedAuthorizer;
        }

        @Override
        public org.apache.nifi.registry.security.authorization.Authorizer getBaseAuthorizer() {
            return this.baseManagedAuthorizer;
        }

        public String getFingerprint() throws AuthorizationAccessException {
            return this.baseManagedAuthorizer.getFingerprint();
        }

        public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
            this.baseManagedAuthorizer.inheritFingerprint(fingerprint);
        }

        public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
            this.baseManagedAuthorizer.checkInheritability(proposedFingerprint);
        }

        public AccessPolicyProvider getAccessPolicyProvider() {
            AccessPolicyProvider baseAccessPolicyProvider = this.baseManagedAuthorizer.getAccessPolicyProvider();
            if (baseAccessPolicyProvider instanceof ConfigurableAccessPolicyProvider) {
                final ConfigurableAccessPolicyProvider baseConfigurableAccessPolicyProvider = (ConfigurableAccessPolicyProvider)baseAccessPolicyProvider;
                return new ConfigurableAccessPolicyProvider(){

                    public String getFingerprint() throws AuthorizationAccessException {
                        return baseConfigurableAccessPolicyProvider.getFingerprint();
                    }

                    public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
                        baseConfigurableAccessPolicyProvider.inheritFingerprint(fingerprint);
                    }

                    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
                        baseConfigurableAccessPolicyProvider.checkInheritability(proposedFingerprint);
                    }

                    public AccessPolicy addAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
                        if (AuthorizerFactory.policyExists((AccessPolicyProvider)baseConfigurableAccessPolicyProvider, accessPolicy)) {
                            throw new IllegalStateException(String.format("Found multiple policies for '%s' with '%s'.", accessPolicy.getResource(), accessPolicy.getAction()));
                        }
                        return baseConfigurableAccessPolicyProvider.addAccessPolicy(accessPolicy);
                    }

                    public boolean isConfigurable(AccessPolicy accessPolicy) {
                        return baseConfigurableAccessPolicyProvider.isConfigurable(accessPolicy);
                    }

                    public AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
                        if (!baseConfigurableAccessPolicyProvider.isConfigurable(accessPolicy)) {
                            throw new IllegalArgumentException("The specified access policy is not support modification.");
                        }
                        return baseConfigurableAccessPolicyProvider.updateAccessPolicy(accessPolicy);
                    }

                    public AccessPolicy deleteAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
                        if (!baseConfigurableAccessPolicyProvider.isConfigurable(accessPolicy)) {
                            throw new IllegalArgumentException("The specified access policy is not support modification.");
                        }
                        return baseConfigurableAccessPolicyProvider.deleteAccessPolicy(accessPolicy);
                    }

                    public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
                        return baseConfigurableAccessPolicyProvider.getAccessPolicies();
                    }

                    public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
                        return baseConfigurableAccessPolicyProvider.getAccessPolicy(identifier);
                    }

                    public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
                        return baseConfigurableAccessPolicyProvider.getAccessPolicy(resourceIdentifier, action);
                    }

                    public UserGroupProvider getUserGroupProvider() {
                        final UserGroupProvider baseUserGroupProvider = baseConfigurableAccessPolicyProvider.getUserGroupProvider();
                        if (baseUserGroupProvider instanceof ConfigurableUserGroupProvider) {
                            final ConfigurableUserGroupProvider baseConfigurableUserGroupProvider = (ConfigurableUserGroupProvider)baseUserGroupProvider;
                            return new ConfigurableUserGroupProvider(){

                                public String getFingerprint() throws AuthorizationAccessException {
                                    return baseConfigurableUserGroupProvider.getFingerprint();
                                }

                                public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
                                    baseConfigurableUserGroupProvider.inheritFingerprint(fingerprint);
                                }

                                public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
                                    baseConfigurableUserGroupProvider.checkInheritability(proposedFingerprint);
                                }

                                public User addUser(User user) throws AuthorizationAccessException {
                                    if (AuthorizerFactory.userExists((UserGroupProvider)baseConfigurableUserGroupProvider, user.getIdentifier(), user.getIdentity())) {
                                        throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", user.getIdentity()));
                                    }
                                    return baseConfigurableUserGroupProvider.addUser(user);
                                }

                                public boolean isConfigurable(User user) {
                                    return baseConfigurableUserGroupProvider.isConfigurable(user);
                                }

                                public User updateUser(User user) throws AuthorizationAccessException {
                                    if (AuthorizerFactory.userExists((UserGroupProvider)baseConfigurableUserGroupProvider, user.getIdentifier(), user.getIdentity())) {
                                        throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", user.getIdentity()));
                                    }
                                    if (!baseConfigurableUserGroupProvider.isConfigurable(user)) {
                                        throw new IllegalArgumentException("The specified user does not support modification.");
                                    }
                                    return baseConfigurableUserGroupProvider.updateUser(user);
                                }

                                public User deleteUser(User user) throws AuthorizationAccessException {
                                    if (!baseConfigurableUserGroupProvider.isConfigurable(user)) {
                                        throw new IllegalArgumentException("The specified user does not support modification.");
                                    }
                                    return baseConfigurableUserGroupProvider.deleteUser(user);
                                }

                                public Group addGroup(Group group) throws AuthorizationAccessException {
                                    if (AuthorizerFactory.groupExists((UserGroupProvider)baseConfigurableUserGroupProvider, group.getIdentifier(), group.getName())) {
                                        throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", group.getName()));
                                    }
                                    if (!AuthorizerFactory.allGroupUsersExist(baseUserGroupProvider, group)) {
                                        throw new IllegalStateException(String.format("Cannot create group '%s' with users that don't exist.", group.getName()));
                                    }
                                    return baseConfigurableUserGroupProvider.addGroup(group);
                                }

                                public boolean isConfigurable(Group group) {
                                    return baseConfigurableUserGroupProvider.isConfigurable(group);
                                }

                                public Group updateGroup(Group group) throws AuthorizationAccessException {
                                    if (AuthorizerFactory.groupExists((UserGroupProvider)baseConfigurableUserGroupProvider, group.getIdentifier(), group.getName())) {
                                        throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", group.getName()));
                                    }
                                    if (!baseConfigurableUserGroupProvider.isConfigurable(group)) {
                                        throw new IllegalArgumentException("The specified group does not support modification.");
                                    }
                                    if (!AuthorizerFactory.allGroupUsersExist(baseUserGroupProvider, group)) {
                                        throw new IllegalStateException(String.format("Cannot update group '%s' to add users that don't exist.", group.getName()));
                                    }
                                    return baseConfigurableUserGroupProvider.updateGroup(group);
                                }

                                public Group deleteGroup(Group group) throws AuthorizationAccessException {
                                    if (!baseConfigurableUserGroupProvider.isConfigurable(group)) {
                                        throw new IllegalArgumentException("The specified group does not support modification.");
                                    }
                                    return baseConfigurableUserGroupProvider.deleteGroup(group);
                                }

                                public Set<User> getUsers() throws AuthorizationAccessException {
                                    return baseConfigurableUserGroupProvider.getUsers();
                                }

                                public User getUser(String identifier) throws AuthorizationAccessException {
                                    return baseConfigurableUserGroupProvider.getUser(identifier);
                                }

                                public User getUserByIdentity(String identity) throws AuthorizationAccessException {
                                    return baseConfigurableUserGroupProvider.getUserByIdentity(identity);
                                }

                                public Set<Group> getGroups() throws AuthorizationAccessException {
                                    return baseConfigurableUserGroupProvider.getGroups();
                                }

                                public Group getGroup(String identifier) throws AuthorizationAccessException {
                                    return baseConfigurableUserGroupProvider.getGroup(identifier);
                                }

                                public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
                                    return baseConfigurableUserGroupProvider.getUserAndGroups(identity);
                                }

                                public void initialize(UserGroupProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
                                    baseConfigurableUserGroupProvider.initialize(initializationContext);
                                }

                                public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
                                    baseConfigurableUserGroupProvider.onConfigured(configurationContext);
                                }

                                public void preDestruction() throws SecurityProviderDestructionException {
                                    baseConfigurableUserGroupProvider.preDestruction();
                                }
                            };
                        }
                        return baseUserGroupProvider;
                    }

                    public void initialize(AccessPolicyProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
                        baseConfigurableAccessPolicyProvider.initialize(initializationContext);
                    }

                    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
                        baseConfigurableAccessPolicyProvider.onConfigured(configurationContext);
                    }

                    public void preDestruction() throws SecurityProviderDestructionException {
                        baseConfigurableAccessPolicyProvider.preDestruction();
                    }
                };
            }
            return baseAccessPolicyProvider;
        }

        public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
            AuthorizationResult result = this.baseManagedAuthorizer.authorize(request);
            AuthorizerFactory.audit((org.apache.nifi.registry.security.authorization.Authorizer)this.baseManagedAuthorizer, request, result);
            return result;
        }

        public void initialize(AuthorizerInitializationContext initializationContext) throws SecurityProviderCreationException {
            this.baseManagedAuthorizer.initialize(initializationContext);
        }

        public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
            this.baseManagedAuthorizer.onConfigured(configurationContext);
            AccessPolicyProvider accessPolicyProvider = this.baseManagedAuthorizer.getAccessPolicyProvider();
            UserGroupProvider userGroupProvider = accessPolicyProvider.getUserGroupProvider();
            Set allPolicies = accessPolicyProvider.getAccessPolicies();
            for (AccessPolicy accessPolicy : allPolicies) {
                if (!AuthorizerFactory.policyExists(allPolicies, accessPolicy)) continue;
                throw new SecurityProviderCreationException(String.format("Found multiple policies for '%s' with '%s'.", accessPolicy.getResource(), accessPolicy.getAction()));
            }
            for (User user : userGroupProvider.getUsers()) {
                if (!AuthorizerFactory.userExists(userGroupProvider, user.getIdentifier(), user.getIdentity())) continue;
                throw new SecurityProviderCreationException(String.format("Found multiple users/user groups with identity '%s'.", user.getIdentity()));
            }
            for (Group group : userGroupProvider.getGroups()) {
                if (!AuthorizerFactory.groupExists(userGroupProvider, group.getIdentifier(), group.getName())) continue;
                throw new SecurityProviderCreationException(String.format("Found multiple users/user groups with name '%s'.", group.getName()));
            }
        }

        public void preDestruction() throws SecurityProviderDestructionException {
            this.baseManagedAuthorizer.preDestruction();
        }
    }

    private static class AuthorizerWrapper
    implements org.apache.nifi.registry.security.authorization.Authorizer,
    WrappedAuthorizer {
        private final org.apache.nifi.registry.security.authorization.Authorizer baseAuthorizer;

        public AuthorizerWrapper(org.apache.nifi.registry.security.authorization.Authorizer baseAuthorizer) {
            this.baseAuthorizer = baseAuthorizer;
        }

        @Override
        public org.apache.nifi.registry.security.authorization.Authorizer getBaseAuthorizer() {
            return this.baseAuthorizer;
        }

        public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
            AuthorizationResult result = this.baseAuthorizer.authorize(request);
            AuthorizerFactory.audit(this.baseAuthorizer, request, result);
            return result;
        }

        public void initialize(AuthorizerInitializationContext initializationContext) throws SecurityProviderCreationException {
            this.baseAuthorizer.initialize(initializationContext);
        }

        public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
            this.baseAuthorizer.onConfigured(configurationContext);
        }

        public void preDestruction() throws SecurityProviderDestructionException {
            this.baseAuthorizer.preDestruction();
        }
    }

    private static interface WrappedAuthorizer {
        public org.apache.nifi.registry.security.authorization.Authorizer getBaseAuthorizer();
    }
}

