/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.vault.core.KeyValueUtilities;
import org.springframework.vault.core.VaultKeyValueMetadataOperations;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.support.VaultMetadataRequest;
import org.springframework.vault.support.VaultMetadataResponse;
import org.springframework.vault.support.VaultResponseSupport;

class VaultKeyValueMetadataTemplate
implements VaultKeyValueMetadataOperations {
    private final VaultOperations vaultOperations;
    private final String basePath;

    VaultKeyValueMetadataTemplate(VaultOperations vaultOperations, String basePath) {
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null");
        this.vaultOperations = vaultOperations;
        this.basePath = basePath;
    }

    @Override
    public VaultMetadataResponse get(String path) {
        VaultResponseSupport<Map> response = this.vaultOperations.read(this.getPath(path), Map.class);
        return response != null ? KeyValueUtilities.fromMap(response.getRequiredData()) : null;
    }

    @Override
    public void put(String path, VaultMetadataRequest body) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        Assert.notNull((Object)body, (String)"Body must not be null");
        this.vaultOperations.write(this.getPath(path), body);
    }

    @Override
    public void delete(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.vaultOperations.delete(this.getPath(path));
    }

    private String getPath(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.basePath + "/metadata/" + path;
    }
}

