/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.springframework.vault.core.KeyValueUtilities;
import org.springframework.vault.core.ReactiveVaultKeyValueAccessor;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.core.VaultListResponse;
import org.springframework.vault.support.VaultResponseSupport;
import reactor.core.publisher.Flux;

abstract class ReactiveVaultKeyValue2Accessor
extends ReactiveVaultKeyValueAccessor {
    private final String path;

    ReactiveVaultKeyValue2Accessor(ReactiveVaultOperations reactiveVaultOperations, String path) {
        super(reactiveVaultOperations, path);
        this.path = path;
    }

    @Override
    public Flux<String> list(String path) {
        return this.doRead(String.format("%s?list=true", this.createBackendPath("metadata", KeyValueUtilities.normalizeListPath(path))), VaultListResponse.class).flatMapMany(response -> {
            List list = (List)((Map)response.getRequiredData()).get("keys");
            return null == list ? Flux.empty() : Flux.fromIterable((Iterable)list);
        });
    }

    @Override
    public VaultKeyValueOperationsSupport.KeyValueBackend getApiVersion() {
        return VaultKeyValueOperationsSupport.KeyValueBackend.KV_2;
    }

    @Override
    JsonNode getJsonNode(VaultResponseSupport<JsonNode> response) {
        return response.getRequiredData().at("/data");
    }

    @Override
    String createDataPath(String path) {
        return this.createBackendPath("data", path);
    }

    String createBackendPath(String segment, String path) {
        return String.format("%s/%s/%s", this.path, segment, path);
    }
}

