/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.connect.validators;

import java.io.File;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class FlowSnapshotValidator
implements ConfigDef.Validator {
    public void ensureValid(String name, Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            throw new ConfigException("Invalid value for property " + name + ": The configured value is expected to be the path to a file");
        }
        String configuredValue = (String)value;
        if (configuredValue.startsWith("http://") || configuredValue.startsWith("https://")) {
            return;
        }
        if (configuredValue.trim().startsWith("{")) {
            return;
        }
        File file = new File(configuredValue);
        if (!file.exists()) {
            throw new ConfigException("The value " + String.valueOf(value) + " configured for the property " + name + " is not valid because no file exists at " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new ConfigException("The value " + String.valueOf(value) + " configured for the property " + name + " is not valid because " + file.getAbsolutePath() + " is a directory, not a file");
        }
    }
}

