/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime.manifest.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.c2.protocol.component.api.ComponentManifest;
import org.apache.nifi.c2.protocol.component.api.ControllerServiceDefinition;
import org.apache.nifi.c2.protocol.component.api.ProcessorDefinition;
import org.apache.nifi.c2.protocol.component.api.ReportingTaskDefinition;
import org.apache.nifi.runtime.manifest.ComponentManifestBuilder;

public class StandardComponentManifestBuilder
implements ComponentManifestBuilder {
    private final List<ProcessorDefinition> processors = new ArrayList<ProcessorDefinition>();
    private final List<ControllerServiceDefinition> controllerServices = new ArrayList<ControllerServiceDefinition>();
    private final List<ReportingTaskDefinition> reportingTasks = new ArrayList<ReportingTaskDefinition>();

    @Override
    public ComponentManifestBuilder addProcessor(ProcessorDefinition processorDefinition) {
        if (processorDefinition == null) {
            throw new IllegalArgumentException("Processor definition cannot be null");
        }
        this.processors.add(processorDefinition);
        return this;
    }

    @Override
    public ComponentManifestBuilder addControllerService(ControllerServiceDefinition controllerServiceDefinition) {
        if (controllerServiceDefinition == null) {
            throw new IllegalArgumentException("Controller Service definition cannot be null");
        }
        this.controllerServices.add(controllerServiceDefinition);
        return this;
    }

    @Override
    public ComponentManifestBuilder addReportingTask(ReportingTaskDefinition reportingTaskDefinition) {
        if (reportingTaskDefinition == null) {
            throw new IllegalArgumentException("Reporting task definition cannot be null");
        }
        this.reportingTasks.add(reportingTaskDefinition);
        return this;
    }

    @Override
    public ComponentManifest build() {
        ComponentManifest componentManifest = new ComponentManifest();
        componentManifest.setProcessors(new ArrayList<ProcessorDefinition>(this.processors));
        componentManifest.setControllerServices(new ArrayList<ControllerServiceDefinition>(this.controllerServices));
        componentManifest.setReportingTasks(new ArrayList<ReportingTaskDefinition>(this.reportingTasks));
        return componentManifest;
    }
}

