/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.nifi.web.api.dto.NodeEventDTO;
import org.apache.nifi.web.api.dto.util.DateTimeAdapter;

@XmlType(name="node")
public class NodeDTO {
    private String nodeId;
    private String address;
    private Integer apiPort;
    private String status;
    private Date heartbeat;
    private Date connectionRequested;
    private Set<String> roles;
    private Integer activeThreadCount;
    private String queued;
    private List<NodeEventDTO> events;
    private Date nodeStartTime;

    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @Schema(description="the time of the nodes's last heartbeat.", accessMode=Schema.AccessMode.READ_ONLY, type="string")
    public Date getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(Date heartbeat) {
        this.heartbeat = heartbeat;
    }

    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @Schema(description="The time of the node's last connection request.", accessMode=Schema.AccessMode.READ_ONLY, type="string")
    public Date getConnectionRequested() {
        return this.connectionRequested;
    }

    public void setConnectionRequested(Date connectionRequested) {
        this.connectionRequested = connectionRequested;
    }

    @Schema(description="The active threads for the NiFi on the node.", accessMode=Schema.AccessMode.READ_ONLY)
    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    @Schema(description="The queue the NiFi on the node.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getQueued() {
        return this.queued;
    }

    public void setQueued(String queued) {
        this.queued = queued;
    }

    @Schema(description="The node's host/ip address.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Schema(description="The id of the node.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Schema(description="The port the node is listening for API requests.", accessMode=Schema.AccessMode.READ_ONLY)
    public Integer getApiPort() {
        return this.apiPort;
    }

    public void setApiPort(Integer port) {
        this.apiPort = port;
    }

    @Schema(description="The node's status.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Schema(description="The node's events.", accessMode=Schema.AccessMode.READ_ONLY)
    public List<NodeEventDTO> getEvents() {
        return this.events;
    }

    public void setEvents(List<NodeEventDTO> events) {
        this.events = events;
    }

    @Schema(description="The roles of this node.", accessMode=Schema.AccessMode.READ_ONLY)
    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @Schema(description="The time at which this Node was last refreshed.", accessMode=Schema.AccessMode.READ_ONLY, type="string")
    public Date getNodeStartTime() {
        return this.nodeStartTime;
    }

    public void setNodeStartTime(Date nodeStartTime) {
        this.nodeStartTime = nodeStartTime;
    }
}

