/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class VersionedFlowCoordinates {
    private String registryId;
    private String storageLocation;
    private String bucketId;
    private String flowId;
    private int version;
    private Boolean latest;

    @Schema(description="The identifier of the Flow Registry that contains the flow")
    public String getRegistryId() {
        return this.registryId;
    }

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    @Schema(description="The location of the Flow Registry that stores the flow")
    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    @Schema(description="The UUID of the bucket that the flow resides in")
    public String getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(String bucketId) {
        this.bucketId = bucketId;
    }

    @Schema(description="The UUID of the flow")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    @Schema(description="The version of the flow")
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Schema(description="Whether or not these coordinates point to the latest version of the flow")
    public Boolean getLatest() {
        return this.latest;
    }

    public void setLatest(Boolean latest) {
        this.latest = latest;
    }

    public int hashCode() {
        return Objects.hash(this.registryId, this.storageLocation, this.bucketId, this.flowId, this.version);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VersionedFlowCoordinates)) {
            return false;
        }
        VersionedFlowCoordinates other = (VersionedFlowCoordinates)obj;
        return Objects.equals(this.storageLocation, other.storageLocation) && Objects.equals(this.bucketId, other.bucketId) && Objects.equals(this.flowId, other.flowId) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return "VersionedFlowCoordinates[bucketId=" + this.bucketId + ", flowId=" + this.flowId + ", version=" + this.version + ", storageLocation=" + this.storageLocation + "]";
    }
}

