/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.config.command;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.Optional;
import org.apache.nifi.minifi.properties.BootstrapProperties;
import org.apache.nifi.minifi.properties.BootstrapPropertiesLoader;
import org.apache.nifi.minifi.properties.ProtectedBootstrapProperties;
import org.apache.nifi.minifi.toolkit.config.transformer.ApplicationPropertiesFileTransformer;
import org.apache.nifi.minifi.toolkit.config.transformer.BootstrapConfigurationFileTransformer;
import org.apache.nifi.minifi.toolkit.config.transformer.FileTransformer;
import org.apache.nifi.properties.AesGcmSensitivePropertyProvider;
import org.apache.nifi.properties.ApplicationProperties;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="encrypt-config", sortOptions=false, mixinStandardHelpOptions=true, usageHelpWidth=160, separator=" ", version={"Java ${java.version} (${java.vendor} ${java.vm.name} ${java.vm.version})"}, descriptionHeading="Description: ", description={"encrypt-config supports protection of sensitive values in Apache MiNiFi"})
public class MiNiFiEncryptConfig
implements Runnable {
    static final String BOOTSTRAP_ROOT_KEY_PROPERTY = "minifi.bootstrap.sensitive.key";
    private static final String WORKING_FILE_NAME_FORMAT = "%s.%d.working";
    private static final int KEY_LENGTH = 32;
    @CommandLine.Option(names={"-b", "--bootstrapConf"}, description={"Path to file containing Bootstrap Configuration [bootstrap.conf] for optional root key and property protection scheme settings"})
    Path bootstrapConfPath;
    @CommandLine.Option(names={"-B", "--outputBootstrapConf"}, description={"Path to output file for Bootstrap Configuration [bootstrap.conf] with root key configured"})
    Path outputBootstrapConf;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void run() {
        this.processBootstrapConf();
    }

    protected void processBootstrapConf() {
        BootstrapProperties unprotectedProperties = BootstrapPropertiesLoader.load((File)this.bootstrapConfPath.toFile());
        this.logger.info("Started processing Bootstrap Configuration [{}]", (Object)this.bootstrapConfPath);
        String newRootKey = this.getRootKey();
        HashSet<String> sensitivePropertyNames = new HashSet<String>(new ProtectedBootstrapProperties(unprotectedProperties).getSensitivePropertyKeys());
        ApplicationPropertiesFileTransformer fileTransformer2 = new ApplicationPropertiesFileTransformer((ApplicationProperties)unprotectedProperties, this.getInputSensitivePropertyProvider(newRootKey), sensitivePropertyNames);
        this.runFileTransformer(fileTransformer2, this.bootstrapConfPath, this.outputBootstrapConf);
        BootstrapConfigurationFileTransformer fileTransformer = new BootstrapConfigurationFileTransformer(BOOTSTRAP_ROOT_KEY_PROPERTY, newRootKey);
        this.runFileTransformer(fileTransformer, Optional.ofNullable(this.outputBootstrapConf).orElse(this.bootstrapConfPath), this.outputBootstrapConf);
        this.logger.info("Completed processing Bootstrap Configuration [{}]", (Object)this.bootstrapConfPath);
    }

    private String getRootKey() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] sensitivePropertiesKeyBinary = new byte[32];
        secureRandom.nextBytes(sensitivePropertiesKeyBinary);
        return HexFormat.of().formatHex(sensitivePropertiesKeyBinary);
    }

    protected void runFileTransformer(FileTransformer fileTransformer, Path inputPath, Path outputPath) {
        Path configuredOutputPath = outputPath == null ? inputPath : outputPath;
        Path workingPath = this.getWorkingPath(configuredOutputPath);
        try {
            fileTransformer.transform(inputPath, workingPath);
            Files.move(workingPath, configuredOutputPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            String message = String.format("Processing Configuration [%s] failed", inputPath);
            throw new UncheckedIOException(message, e);
        }
    }

    protected SensitivePropertyProvider getInputSensitivePropertyProvider(String keyHex) {
        return new AesGcmSensitivePropertyProvider(keyHex);
    }

    private Path getWorkingPath(Path resourcePath) {
        Path fileName = resourcePath.getFileName();
        String workingFileName = String.format(WORKING_FILE_NAME_FORMAT, fileName, System.currentTimeMillis());
        return resourcePath.resolveSibling(workingFileName);
    }
}

