/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.jetty.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ScopedHandler;

public class HeaderWriterHandler
extends ScopedHandler {
    protected static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    protected static final String CONTENT_SECURITY_POLICY = "frame-ancestors 'self'";
    protected static final String FRAME_OPTIONS_HEADER = "X-Frame-Options";
    protected static final String FRAME_OPTIONS = "SAMEORIGIN";
    protected static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    protected static final String STRICT_TRANSPORT_SECURITY = "max-age=31540000";
    protected static final String XSS_PROTECTION_HEADER = "X-XSS-Protection";
    protected static final String XSS_PROTECTION = "1; mode=block";

    public void doHandle(String target, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader(CONTENT_SECURITY_POLICY_HEADER, CONTENT_SECURITY_POLICY);
        httpServletResponse.setHeader(FRAME_OPTIONS_HEADER, FRAME_OPTIONS);
        httpServletResponse.setHeader(XSS_PROTECTION_HEADER, XSS_PROTECTION);
        if (httpServletRequest.isSecure()) {
            httpServletResponse.setHeader(STRICT_TRANSPORT_SECURITY_HEADER, STRICT_TRANSPORT_SECURITY);
        }
    }
}

