/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jetty.configuration.connector.alpn;

import java.net.SocketAddress;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.alpn.server.ALPNServerConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardALPNProcessor
implements ALPNProcessor.Server,
SslHandshakeListener {
    private static final Logger logger = LoggerFactory.getLogger(StandardALPNProcessor.class);

    public boolean appliesTo(SSLEngine sslEngine) {
        return true;
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        logger.debug("Configuring Connection Remote Address [{}]", (Object)connection.getEndPoint().getRemoteSocketAddress());
        ALPNServerConnection serverConnection = (ALPNServerConnection)connection;
        ProtocolSelector protocolSelector = new ProtocolSelector(serverConnection);
        sslEngine.setHandshakeApplicationProtocolSelector(protocolSelector);
        SslConnection.DecryptedEndPoint endPoint = (SslConnection.DecryptedEndPoint)serverConnection.getEndPoint();
        endPoint.getSslConnection().addHandshakeListener((SslHandshakeListener)protocolSelector);
    }

    private static final class ProtocolSelector
    implements BiFunction<SSLEngine, List<String>, String>,
    SslHandshakeListener {
        private final ALPNServerConnection serverConnection;

        private ProtocolSelector(ALPNServerConnection connection) {
            this.serverConnection = connection;
        }

        @Override
        public String apply(SSLEngine sslEngine, List<String> protocols) {
            String protocol = null;
            try {
                this.serverConnection.select(protocols);
                protocol = this.serverConnection.getProtocol();
                logger.debug("Connection Remote Address [{}] Application Layer Protocol [{}] selected", (Object)this.serverConnection.getEndPoint().getRemoteSocketAddress(), (Object)protocol);
            }
            catch (Throwable e) {
                logger.debug("Connection Remote Address [{}] Application Layer Protocols {} not supported", (Object)this.serverConnection.getEndPoint().getRemoteSocketAddress(), protocols);
            }
            return protocol;
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            SocketAddress remoteAddress = this.serverConnection.getEndPoint().getRemoteSocketAddress();
            SSLSession session = event.getSSLEngine().getSession();
            logger.debug("Connection Remote Address [{}] Handshake Succeeded [{}] Cipher Suite [{}]", new Object[]{remoteAddress, session.getProtocol(), session.getCipherSuite()});
            String protocol = this.serverConnection.getProtocol();
            if (protocol == null) {
                logger.debug("Connection Remote Address [{}] Application Layer Protocol not supported", (Object)remoteAddress);
                this.serverConnection.unsupported();
            }
        }

        public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
            logger.debug("Connection Remote Address [{}] Handshake Failed", (Object)this.serverConnection.getEndPoint().getRemoteSocketAddress(), (Object)failure);
        }
    }
}

