/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.kms;

import java.security.KeyStore;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.security.kms.KeyStoreKeyProvider;
import org.apache.nifi.security.kms.configuration.KeyProviderConfiguration;
import org.apache.nifi.security.kms.configuration.KeyStoreKeyProviderConfiguration;

public class KeyProviderFactory {
    public static KeyProvider getKeyProvider(KeyProviderConfiguration<?> configuration) {
        if (!(configuration instanceof KeyStoreKeyProviderConfiguration)) {
            throw new UnsupportedOperationException(String.format("Key Provider [%s] not supported", configuration.getKeyProviderClass().getName()));
        }
        KeyStoreKeyProviderConfiguration providerConfiguration = (KeyStoreKeyProviderConfiguration)configuration;
        KeyStore keyStore = providerConfiguration.getKeyStore();
        KeyStoreKeyProvider keyProvider = new KeyStoreKeyProvider(keyStore, providerConfiguration.getKeyPassword());
        return keyProvider;
    }
}

