/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.wali;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.nifi.stream.io.ByteCountingInputStream;
import org.apache.nifi.stream.io.LimitingInputStream;
import org.apache.nifi.wali.ByteArrayDataOutputStream;
import org.apache.nifi.wali.JournalRecovery;
import org.apache.nifi.wali.JournalSummary;
import org.apache.nifi.wali.ObjectPool;
import org.apache.nifi.wali.RecordLookup;
import org.apache.nifi.wali.StandardJournalRecovery;
import org.apache.nifi.wali.StandardJournalSummary;
import org.apache.nifi.wali.WriteAheadJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wali.SerDe;
import org.wali.SerDeFactory;
import org.wali.UpdateType;

public class LengthDelimitedJournal<T>
implements WriteAheadJournal<T> {
    private static final Logger logger = LoggerFactory.getLogger(LengthDelimitedJournal.class);
    private static final int DEFAULT_MAX_IN_HEAP_SERIALIZATION_BYTES = 0x500000;
    private static final JournalSummary INACTIVE_JOURNAL_SUMMARY = new StandardJournalSummary(-1L, -1L, 0);
    private static final int JOURNAL_ENCODING_VERSION = 1;
    private static final byte TRANSACTION_FOLLOWS = 64;
    private static final byte JOURNAL_COMPLETE = 127;
    private static final int NUL_BYTE = 0;
    private final File journalFile;
    private final File overflowDirectory;
    private final long initialTransactionId;
    private final SerDeFactory<T> serdeFactory;
    private final ObjectPool<ByteArrayDataOutputStream> streamPool;
    private final int maxInHeapSerializationBytes;
    private SerDe<T> serde;
    private FileOutputStream fileOut;
    private BufferedOutputStream bufferedOut;
    private long currentTransactionId;
    private int transactionCount;
    private boolean headerWritten = false;
    private volatile Throwable poisonCause = null;
    private volatile boolean closed = false;
    private final ByteBuffer transactionPreamble = ByteBuffer.allocate(12);

    public LengthDelimitedJournal(File journalFile, SerDeFactory<T> serdeFactory, ObjectPool<ByteArrayDataOutputStream> streamPool, long initialTransactionId) {
        this(journalFile, serdeFactory, streamPool, initialTransactionId, 0x500000);
    }

    public LengthDelimitedJournal(File journalFile, SerDeFactory<T> serdeFactory, ObjectPool<ByteArrayDataOutputStream> streamPool, long initialTransactionId, int maxInHeapSerializationBytes) {
        this.journalFile = journalFile;
        this.overflowDirectory = new File(journalFile.getParentFile(), "overflow-" + LengthDelimitedJournal.getBaseFilename(journalFile));
        this.serdeFactory = serdeFactory;
        this.serde = serdeFactory.createSerDe(null);
        this.streamPool = streamPool;
        this.initialTransactionId = initialTransactionId;
        this.currentTransactionId = initialTransactionId;
        this.maxInHeapSerializationBytes = maxInHeapSerializationBytes;
    }

    @Override
    public void dispose() {
        logger.debug("Deleting Journal {} because it is now encapsulated in the latest Snapshot", (Object)this.journalFile.getName());
        if (!this.journalFile.delete() && this.journalFile.exists()) {
            logger.warn("Unable to delete expired journal file " + String.valueOf(this.journalFile) + "; this file should be deleted manually.");
        }
        if (this.overflowDirectory.exists()) {
            File[] overflowFiles = this.overflowDirectory.listFiles();
            if (overflowFiles == null) {
                logger.warn("Unable to obtain listing of files that exist in 'overflow directory' " + String.valueOf(this.overflowDirectory) + " - this directory and any files within it can now be safely removed manually");
                return;
            }
            for (File overflowFile : overflowFiles) {
                if (overflowFile.delete() || !overflowFile.exists()) continue;
                logger.warn("After expiring journal file " + String.valueOf(this.journalFile) + ", unable to remove 'overflow file' " + String.valueOf(overflowFile) + " - this file should be removed manually");
            }
            if (!this.overflowDirectory.delete()) {
                logger.warn("After expiring journal file " + String.valueOf(this.journalFile) + ", unable to remove 'overflow directory' " + String.valueOf(this.overflowDirectory) + " - this file should be removed manually");
            }
        }
    }

    private static String getBaseFilename(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return name;
        }
        return name.substring(0, index);
    }

    private synchronized OutputStream getOutputStream() throws FileNotFoundException {
        if (this.fileOut == null) {
            this.fileOut = new FileOutputStream(this.journalFile);
            this.bufferedOut = new BufferedOutputStream(this.fileOut);
        }
        return this.bufferedOut;
    }

    @Override
    public synchronized boolean isHealthy() {
        return !this.closed && !this.isPoisoned();
    }

    private boolean isPoisoned() {
        return this.poisonCause != null;
    }

    @Override
    public synchronized void writeHeader() throws IOException {
        try {
            DataOutputStream outStream = new DataOutputStream(this.getOutputStream());
            outStream.writeUTF(LengthDelimitedJournal.class.getName());
            outStream.writeInt(1);
            this.serde = this.serdeFactory.createSerDe(null);
            outStream.writeUTF(this.serde.getClass().getName());
            outStream.writeInt(this.serde.getVersion());
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 DataOutputStream dos = new DataOutputStream(baos);){
                this.serde.writeHeader(dos);
                dos.flush();
                int serdeHeaderLength = baos.size();
                outStream.writeInt(serdeHeaderLength);
                baos.writeTo(outStream);
            }
            outStream.flush();
        }
        catch (Throwable t) {
            this.poison(t);
            IOException ioe = t instanceof IOException ? (IOException)t : new IOException("Failed to create journal file " + String.valueOf(this.journalFile), t);
            logger.error("Failed to create new journal file {} due to {}", new Object[]{this.journalFile, ioe.toString(), ioe});
            throw ioe;
        }
        this.headerWritten = true;
    }

    private synchronized SerDeAndVersion validateHeader(DataInputStream in) throws IOException {
        SerDe<T> serde;
        String journalClassName = in.readUTF();
        logger.debug("Write Ahead Log Class Name for {} is {}", (Object)this.journalFile, (Object)journalClassName);
        if (!LengthDelimitedJournal.class.getName().equals(journalClassName)) {
            throw new IOException("Invalid header information - " + String.valueOf(this.journalFile) + " does not appear to be a valid journal file.");
        }
        int encodingVersion = in.readInt();
        logger.debug("Encoding version for {} is {}", (Object)this.journalFile, (Object)encodingVersion);
        if (encodingVersion > 1) {
            throw new IOException("Cannot read journal file " + String.valueOf(this.journalFile) + " because it is encoded using veresion " + encodingVersion + " but this version of the code only understands version 1 and below");
        }
        String serdeClassName = in.readUTF();
        logger.debug("Serde Class Name for {} is {}", (Object)this.journalFile, (Object)serdeClassName);
        try {
            serde = this.serdeFactory.createSerDe(serdeClassName);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Cannot read journal file " + String.valueOf(this.journalFile) + " because the serializer/deserializer used was " + serdeClassName + " but this repository is configured to use a different type of serializer/deserializer");
        }
        int serdeVersion = in.readInt();
        logger.debug("Serde version is {}", (Object)serdeVersion);
        if (serdeVersion > serde.getVersion()) {
            throw new IOException("Cannot read journal file " + String.valueOf(this.journalFile) + " because it is encoded using veresion " + encodingVersion + " of the serializer/deserializer but this version of the code only understands version " + serde.getVersion() + " and below");
        }
        int serdeHeaderLength = in.readInt();
        LimitingInputStream serdeHeaderIn = new LimitingInputStream((InputStream)in, (long)serdeHeaderLength);
        DataInputStream dis = new DataInputStream((InputStream)serdeHeaderIn);
        serde.readHeader(dis);
        return new SerDeAndVersion(this, serde, serdeVersion);
    }

    protected void createOverflowDirectory(Path path) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Collection<T> records, RecordLookup<T> recordLookup) throws IOException {
        if (!this.headerWritten) {
            throw new IllegalStateException("Cannot update journal file " + String.valueOf(this.journalFile) + " because no header has been written yet.");
        }
        if (records.isEmpty()) {
            return;
        }
        this.checkState();
        File overflowFile = null;
        ByteArrayDataOutputStream bados = this.streamPool.borrowObject();
        try {
            long transactionId;
            FileOutputStream overflowFileOut = null;
            try {
                DataOutputStream dataOut = bados.getDataOutputStream();
                for (T record : records) {
                    Object recordId = this.serde.getRecordIdentifier(record);
                    T previousRecordState = recordLookup.lookup(recordId);
                    this.serde.serializeEdit(previousRecordState, record, dataOut);
                    int size = bados.getByteArrayOutputStream().size();
                    if (!this.serde.isWriteExternalFileReferenceSupported() || size <= this.maxInHeapSerializationBytes) continue;
                    if (!this.overflowDirectory.exists()) {
                        this.createOverflowDirectory(this.overflowDirectory.toPath());
                    }
                    overflowFile = new File(this.overflowDirectory, UUID.randomUUID().toString());
                    logger.debug("Length of update with {} records exceeds in-memory max of {} bytes. Overflowing to {}", new Object[]{records.size(), this.maxInHeapSerializationBytes, overflowFile});
                    overflowFileOut = new FileOutputStream(overflowFile);
                    bados.getByteArrayOutputStream().writeTo(overflowFileOut);
                    bados.getByteArrayOutputStream().reset();
                    dataOut = new DataOutputStream(new BufferedOutputStream(overflowFileOut));
                    this.serde.writeExternalFileReference(overflowFile, bados.getDataOutputStream());
                }
                dataOut.flush();
                if (overflowFileOut != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Length of update to overflow file is {} bytes", (Object)overflowFile.length());
                    }
                    overflowFileOut.getFD().sync();
                }
            }
            finally {
                if (overflowFileOut != null) {
                    try {
                        overflowFileOut.close();
                    }
                    catch (Exception e) {
                        logger.warn("Failed to close open file handle to overflow file {}", (Object)overflowFile, (Object)e);
                    }
                }
            }
            ByteArrayOutputStream baos = bados.getByteArrayOutputStream();
            OutputStream out = this.getOutputStream();
            LengthDelimitedJournal lengthDelimitedJournal = this;
            synchronized (lengthDelimitedJournal) {
                this.checkState();
                try {
                    transactionId = this.currentTransactionId++;
                    ++this.transactionCount;
                    this.transactionPreamble.clear();
                    this.transactionPreamble.putLong(transactionId);
                    this.transactionPreamble.putInt(baos.size());
                    out.write(64);
                    out.write(this.transactionPreamble.array());
                    baos.writeTo(out);
                    out.flush();
                }
                catch (Throwable t) {
                    this.poison(t);
                    throw t;
                }
            }
            logger.debug("Wrote Transaction {} to journal {} with length {} and {} records", new Object[]{transactionId, this.journalFile, baos.size(), records.size()});
        }
        catch (Throwable t) {
            this.poison(t);
            if (overflowFile != null && !overflowFile.delete() && overflowFile.exists()) {
                logger.warn("Failed to cleanup temporary overflow file " + String.valueOf(overflowFile) + " - this file should be cleaned up manually.");
            }
            throw t;
        }
        finally {
            this.streamPool.returnObject(bados);
        }
    }

    private void checkState() throws IOException {
        Throwable cause = this.poisonCause;
        if (cause != null) {
            logger.debug("Cannot update Write Ahead Log because the log has already been poisoned", cause);
            throw new IOException("Cannot update journal file " + String.valueOf(this.journalFile) + " because this journal has already encountered a failure when attempting to write to the file. If the repository is able to checkpoint, then this problem will resolve itself. However, if the repository is unable to be checkpointed (for example, due to being out of storage space or having too many open files), then this issue may require manual intervention.", cause);
        }
        if (this.closed) {
            throw new IOException("Cannot update journal file " + String.valueOf(this.journalFile) + " because this journal has already been closed");
        }
    }

    protected void poison(Throwable t) {
        this.poisonCause = t;
        logger.error("Marking Write-Ahead journal file {} as poisoned due to {}", new Object[]{this.journalFile, t, t});
        try {
            if (this.fileOut != null) {
                this.fileOut.close();
            }
            this.closed = true;
        }
        catch (IOException innerIOE) {
            t.addSuppressed(innerIOE);
        }
    }

    @Override
    public synchronized void fsync() throws IOException {
        this.checkState();
        try {
            if (this.fileOut != null) {
                this.fileOut.getChannel().force(false);
            }
        }
        catch (IOException ioe) {
            this.poison(ioe);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.fileOut != null) {
                if (!this.isPoisoned()) {
                    this.fileOut.write(127);
                }
                this.fileOut.close();
            }
        }
        catch (IOException ioe) {
            this.poison(ioe);
        }
    }

    @Override
    public JournalRecovery recoverRecords(Map<Object, T> recordMap, Set<String> swapLocations) throws IOException {
        boolean eofException;
        int updateCount;
        long maxTransactionId;
        block36: {
            maxTransactionId = -1L;
            updateCount = 0;
            eofException = false;
            logger.info("Recovering records from journal {}", (Object)this.journalFile);
            double journalLength = this.journalFile.length();
            try (FileInputStream fis = new FileInputStream(this.journalFile);
                 BufferedInputStream bufferedIn = new BufferedInputStream(fis);
                 ByteCountingInputStream byteCountingIn = new ByteCountingInputStream((InputStream)bufferedIn);
                 DataInputStream in = new DataInputStream((InputStream)byteCountingIn);){
                try {
                    SerDeAndVersion serdeAndVersion = this.validateHeader(in);
                    SerDe<T> serde = serdeAndVersion.getSerDe();
                    int transactionIndicator = in.read();
                    if (transactionIndicator != 64 && transactionIndicator != 127 && transactionIndicator != -1) {
                        throw new IOException("After reading " + byteCountingIn.getBytesConsumed() + " bytes from " + String.valueOf(this.journalFile) + ", encountered unexpected value of " + transactionIndicator + " for the Transaction Indicator. This journal may have been corrupted.");
                    }
                    long consumedAtLog = 0L;
                    HashMap<Object, Iterator<Object>> transactionRecordMap = new HashMap<Object, Iterator<Object>>();
                    HashSet<Object> idsRemoved = new HashSet<Object>();
                    HashSet<String> swapLocationsRemoved = new HashSet<String>();
                    HashSet<String> swapLocationsAdded = new HashSet<String>();
                    int transactionUpdates = 0;
                    while (transactionIndicator == 64) {
                        transactionRecordMap.clear();
                        idsRemoved.clear();
                        swapLocationsRemoved.clear();
                        swapLocationsAdded.clear();
                        transactionUpdates = 0;
                        long transactionId = in.readLong();
                        maxTransactionId = Math.max(maxTransactionId, transactionId);
                        int transactionLength = in.readInt();
                        LimitingInputStream transactionLimitingIn = new LimitingInputStream((InputStream)in, (long)transactionLength);
                        ByteCountingInputStream transactionByteCountingIn = new ByteCountingInputStream((InputStream)transactionLimitingIn);
                        DataInputStream transactionDis = new DataInputStream((InputStream)transactionByteCountingIn);
                        while (transactionByteCountingIn.getBytesConsumed() < (long)transactionLength || serde.isMoreInExternalFile()) {
                            Iterator<Object> record = serde.deserializeEdit(transactionDis, recordMap, serdeAndVersion.getVersion());
                            Object recordId = serde.getRecordIdentifier(record);
                            UpdateType updateType = serde.getUpdateType(record);
                            switch (updateType) {
                                case DELETE: {
                                    idsRemoved.add(recordId);
                                    transactionRecordMap.remove(recordId);
                                    break;
                                }
                                case SWAP_IN: {
                                    String location = serde.getLocation(record);
                                    if (location == null) {
                                        logger.error("Recovered SWAP_IN record from edit log, but it did not contain a Location; skipping record");
                                        break;
                                    }
                                    swapLocationsRemoved.add(location);
                                    swapLocationsAdded.remove(location);
                                    transactionRecordMap.put(recordId, record);
                                    break;
                                }
                                case SWAP_OUT: {
                                    String location = serde.getLocation(record);
                                    if (location == null) {
                                        logger.error("Recovered SWAP_OUT record from edit log, but it did not contain a Location; skipping record");
                                        break;
                                    }
                                    swapLocationsRemoved.remove(location);
                                    swapLocationsAdded.add(location);
                                    idsRemoved.add(recordId);
                                    transactionRecordMap.remove(recordId);
                                    break;
                                }
                                default: {
                                    transactionRecordMap.put(recordId, record);
                                    idsRemoved.remove(recordId);
                                }
                            }
                            ++transactionUpdates;
                        }
                        for (Object id : idsRemoved) {
                            recordMap.remove(id);
                        }
                        recordMap.putAll(transactionRecordMap);
                        swapLocations.removeAll(swapLocationsRemoved);
                        swapLocations.addAll(swapLocationsAdded);
                        updateCount += transactionUpdates;
                        transactionIndicator = in.read();
                        if (transactionIndicator != 64 && transactionIndicator != 127 && transactionIndicator != -1) {
                            throw new IOException("After reading " + byteCountingIn.getBytesConsumed() + " bytes from " + String.valueOf(this.journalFile) + ", encountered unexpected value of " + transactionIndicator + " for the Transaction Indicator. This journal may have been corrupted.");
                        }
                        long consumed = byteCountingIn.getBytesConsumed();
                        if (consumed - consumedAtLog <= 50000000L) continue;
                        double percentage = (double)consumed / journalLength * 100.0;
                        String pct = new DecimalFormat("#.00").format(percentage);
                        logger.info("{}% of the way finished recovering journal {}, having recovered {} updates", new Object[]{pct, this.journalFile, updateCount});
                        consumedAtLog = consumed;
                    }
                }
                catch (EOFException eof) {
                    eofException = true;
                    logger.warn("Encountered unexpected End-of-File when reading journal file {}; assuming that NiFi was shutdown unexpectedly and continuing recovery", (Object)this.journalFile);
                }
                catch (Exception e) {
                    if (this.remainingBytesAllNul(in)) {
                        logger.warn("Failed to recover some of the data from Write-Ahead Log Journal because encountered trailing NUL bytes. This will sometimes happen after a sudden power loss. The rest of this journal file will be skipped for recovery purposes.The following Exception was encountered while recovering the updates to the journal:", (Throwable)e);
                        break block36;
                    }
                    throw e;
                }
            }
        }
        logger.info("Successfully recovered {} updates from journal {}", (Object)updateCount, (Object)this.journalFile);
        return new StandardJournalRecovery(updateCount, maxTransactionId, eofException);
    }

    private boolean remainingBytesAllNul(InputStream in) throws IOException {
        int nextByte;
        while ((nextByte = in.read()) != -1) {
            if (nextByte == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized JournalSummary getSummary() {
        if (this.transactionCount < 1) {
            return INACTIVE_JOURNAL_SUMMARY;
        }
        return new StandardJournalSummary(this.initialTransactionId, this.currentTransactionId - 1L, this.transactionCount);
    }

    private class SerDeAndVersion {
        private final SerDe<T> serde;
        private final int version;

        public SerDeAndVersion(LengthDelimitedJournal lengthDelimitedJournal, SerDe<T> serde, int version) {
            this.serde = serde;
            this.version = version;
        }

        public SerDe<T> getSerDe() {
            return this.serde;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

