/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.scrypt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.nifi.security.crypto.key.DerivedKey;
import org.apache.nifi.security.crypto.key.DerivedKeyProvider;
import org.apache.nifi.security.crypto.key.DerivedKeySpec;
import org.apache.nifi.security.crypto.key.DerivedSecretKey;
import org.apache.nifi.security.crypto.key.scrypt.ScryptDerivedKeyParameterSpec;
import org.bouncycastle.crypto.generators.SCrypt;

public class ScryptDerivedKeyProvider
implements DerivedKeyProvider<ScryptDerivedKeyParameterSpec> {
    private static final String SERIALIZED_FORMAT = "$s0$%s$%s$%s";
    private static final int HEXADECIMAL_RADIX = 16;
    private static final int LOG_BASE_2 = 2;
    private static final int COST_BITS = 16;
    private static final int SIZE_BITS = 8;
    private static final Charset PASSWORD_CHARACTER_SET = StandardCharsets.UTF_8;
    private static final Base64.Encoder encoder = Base64.getEncoder().withoutPadding();

    @Override
    public DerivedKey getDerivedKey(DerivedKeySpec<ScryptDerivedKeyParameterSpec> derivedKeySpec) {
        byte[] password = new String(derivedKeySpec.getPassword()).getBytes(PASSWORD_CHARACTER_SET);
        ScryptDerivedKeyParameterSpec parameterSpec = derivedKeySpec.getParameterSpec();
        byte[] salt = parameterSpec.getSalt();
        int cost = parameterSpec.getCost();
        int blockSize = parameterSpec.getBlockSize();
        int parallelization = parameterSpec.getParallelization();
        int derivedKeyLength = derivedKeySpec.getDerivedKeyLength();
        byte[] derivedKeyBytes = SCrypt.generate((byte[])password, (byte[])salt, (int)cost, (int)blockSize, (int)parallelization, (int)derivedKeyLength);
        String serialized = this.getSerialized(derivedKeyBytes, parameterSpec);
        return new DerivedSecretKey(derivedKeyBytes, derivedKeySpec.getAlgorithm(), serialized);
    }

    private String getSerialized(byte[] derivedKeyBytes, ScryptDerivedKeyParameterSpec parameterSpec) {
        String parametersEncoded = this.getParametersEncoded(parameterSpec);
        String derivedKeyEncoded = encoder.encodeToString(derivedKeyBytes);
        String saltEncoded = encoder.encodeToString(parameterSpec.getSalt());
        return String.format(SERIALIZED_FORMAT, parametersEncoded, saltEncoded, derivedKeyEncoded);
    }

    private String getParametersEncoded(ScryptDerivedKeyParameterSpec parameterSpec) {
        long cost = this.log2(parameterSpec.getCost()) << 16;
        long blockSize = parameterSpec.getBlockSize() << 8;
        long parallelization = parameterSpec.getParallelization();
        long parameters = cost | blockSize | parallelization;
        return Long.toString(parameters, 16);
    }

    private long log2(int number) {
        double log = Math.log(number);
        double logBase2 = Math.log(2.0);
        double log2 = log / logBase2;
        return Math.round(log2);
    }
}

