/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ClassUtils;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceProxyWrapper;
import org.apache.nifi.controller.service.ControllerServiceDisabledException;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceInvocationHandler
implements ControllerServiceInvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(StandardControllerServiceInvocationHandler.class);
    private static final Method PROXY_WRAPPER_GET_WRAPPED_METHOD;
    private static final Set<Method> validDisabledMethods;
    private final ControllerService originalService;
    private final AtomicReference<ControllerServiceNode> serviceNodeHolder = new AtomicReference<Object>(null);
    private final ExtensionManager extensionManager;

    public StandardControllerServiceInvocationHandler(ExtensionManager extensionManager, ControllerService originalService) {
        this(extensionManager, originalService, null);
    }

    public StandardControllerServiceInvocationHandler(ExtensionManager extensionManager, ControllerService originalService, ControllerServiceNode serviceNode) {
        this.extensionManager = extensionManager;
        this.originalService = originalService;
        this.serviceNodeHolder.set(serviceNode);
    }

    public void setServiceNode(ControllerServiceNode serviceNode) {
        this.serviceNodeHolder.set(serviceNode);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        block10: {
            boolean disabled;
            String methodName = method.getName();
            if ("initialize".equals(methodName) || "onPropertyModified".equals(methodName)) {
                throw new UnsupportedOperationException(String.valueOf(method) + " may only be invoked by the NiFi framework");
            }
            ControllerServiceNode node = this.serviceNodeHolder.get();
            ControllerServiceState state = node.getState();
            boolean bl = disabled = state != ControllerServiceState.ENABLED;
            if (disabled && !validDisabledMethods.contains(method)) {
                throw new ControllerServiceDisabledException(node.getIdentifier(), "Cannot invoke method " + String.valueOf(method) + " on Controller Service with identifier " + this.serviceNodeHolder.get().getIdentifier() + " because the Controller Service's State is currently " + String.valueOf(state));
            }
            ClassLoader callerClassLoader = Thread.currentThread().getContextClassLoader();
            NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)this.originalService.getClass(), (String)this.originalService.getIdentifier());
            try {
                ClassLoader serviceClassLoader = Thread.currentThread().getContextClassLoader();
                object = this.invoke(this.originalService, method, args, serviceClassLoader, callerClassLoader);
                if (narCloseable == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (narCloseable != null) {
                        try {
                            narCloseable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            narCloseable.close();
        }
        return object;
    }

    private boolean isInHierarchy(ClassLoader objectClassLoader, ClassLoader classLoaderHierarchy) {
        if (classLoaderHierarchy == null) {
            return false;
        }
        if (objectClassLoader == classLoaderHierarchy) {
            return true;
        }
        return this.isInHierarchy(objectClassLoader, classLoaderHierarchy.getParent());
    }

    private Object proxy(Object bareObject, Class<?> declaredType) {
        if (bareObject == null) {
            return null;
        }
        if (declaredType == null || !declaredType.isInterface()) {
            return bareObject;
        }
        if (bareObject.getClass().getClassLoader() == null) {
            return bareObject;
        }
        List interfaces = ClassUtils.getAllInterfaces(bareObject.getClass());
        if (interfaces == null || interfaces.isEmpty()) {
            return bareObject;
        }
        if (!interfaces.contains(ControllerServiceProxyWrapper.class)) {
            interfaces.add(ControllerServiceProxyWrapper.class);
        }
        Class[] interfaceTypes = interfaces.toArray(new Class[0]);
        ProxiedReturnObjectInvocationHandler invocationHandler = new ProxiedReturnObjectInvocationHandler(bareObject);
        return Proxy.newProxyInstance(bareObject.getClass().getClassLoader(), interfaceTypes, (InvocationHandler)invocationHandler);
    }

    private Object[] unwrapProxies(Object[] values, ClassLoader expectedClassLoader, Method method) {
        if (!this.containsWrappedProxy(values)) {
            return values;
        }
        Object[] unwrappedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            unwrappedValues[i] = this.unwrap(values[i], expectedClassLoader, method);
        }
        return unwrappedValues;
    }

    private Object unwrap(Object value, ClassLoader expectedClassLoader, Method method) {
        if (!this.isWrappedProxy(value)) {
            return value;
        }
        ControllerServiceProxyWrapper wrapper = (ControllerServiceProxyWrapper)value;
        Object wrapped = wrapper.getWrapped();
        if (wrapped == null) {
            return null;
        }
        ClassLoader wrappedClassLoader = wrapped.getClass().getClassLoader();
        if (this.isInHierarchy(wrappedClassLoader, expectedClassLoader)) {
            logger.trace("Unwrapped {} to be used by {} when calling {}", new Object[]{wrapped, this.originalService, method});
            return wrapped;
        }
        logger.trace("Will not unwrap {} because even though it is a wrapped proxy object, the wrapped object's ClassLoader is {}, not {}", new Object[]{value, wrappedClassLoader, expectedClassLoader});
        return value;
    }

    private boolean containsWrappedProxy(Object[] values) {
        if (values == null || values.length == 0) {
            return false;
        }
        for (Object value : values) {
            if (!this.isWrappedProxy(value)) continue;
            return true;
        }
        return false;
    }

    private boolean isWrappedProxy(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> valueClass = value.getClass();
        return ControllerServiceProxyWrapper.class.isAssignableFrom(valueClass) && Proxy.isProxyClass(valueClass);
    }

    private Object invoke(Object bareObject, Method method, Object[] args, ClassLoader bareObjectClassLoader, ClassLoader callerClassLoader) throws IllegalAccessException, InvocationTargetException {
        Object[] unwrappedArgs = this.unwrapProxies(args, bareObjectClassLoader, method);
        Object returnedFromBareObject = method.invoke(bareObject, unwrappedArgs);
        if (returnedFromBareObject == null || this.isInHierarchy(returnedFromBareObject.getClass().getClassLoader(), callerClassLoader)) {
            return returnedFromBareObject;
        }
        return this.proxy(returnedFromBareObject, method.getReturnType());
    }

    static {
        HashSet<Method> validMethods = new HashSet<Method>();
        validMethods.addAll(Arrays.asList(ControllerService.class.getMethods()));
        validMethods.addAll(Arrays.asList(Object.class.getMethods()));
        validDisabledMethods = Collections.unmodifiableSet(validMethods);
        try {
            PROXY_WRAPPER_GET_WRAPPED_METHOD = ControllerServiceProxyWrapper.class.getMethod("getWrapped", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)"Could not find getWrapped Method for ProxyWrapper");
        }
    }

    private class ProxiedReturnObjectInvocationHandler
    implements InvocationHandler {
        private final Object bareObject;
        private ClassLoader bareObjectClassLoader;

        public ProxiedReturnObjectInvocationHandler(Object bareObject) {
            this.bareObject = bareObject;
            this.bareObjectClassLoader = bareObject.getClass().getClassLoader();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (PROXY_WRAPPER_GET_WRAPPED_METHOD.equals(method)) {
                return this.bareObject;
            }
            ClassLoader callerClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.bareObjectClassLoader);
                Object object = StandardControllerServiceInvocationHandler.this.invoke(this.bareObject, method, args, this.bareObjectClassLoader, callerClassLoader);
                return object;
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
            finally {
                Thread.currentThread().setContextClassLoader(callerClassLoader);
            }
        }
    }
}

