/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.flowanalysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flowanalysis.FlowAnalysisRule;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleContext;
import org.apache.nifi.parameter.ParameterLookup;

public abstract class AbstractFlowAnalysisRuleContext
implements FlowAnalysisRuleContext {
    private final FlowAnalysisRuleNode flowAnalysisRuleNode;
    private final Map<PropertyDescriptor, String> properties;
    private final ControllerServiceProvider serviceProvider;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final ParameterLookup parameterLookup;

    public AbstractFlowAnalysisRuleContext(FlowAnalysisRuleNode flowAnalysisRule, Map<PropertyDescriptor, String> properties, ControllerServiceProvider controllerServiceProvider, ParameterLookup parameterLookup) {
        this.flowAnalysisRuleNode = flowAnalysisRule;
        this.properties = Collections.unmodifiableMap(properties);
        this.serviceProvider = controllerServiceProvider;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        this.parameterLookup = parameterLookup;
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor desc = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    protected FlowAnalysisRule getFlowAnalysisRule() {
        return this.flowAnalysisRuleNode.getFlowAnalysisRule();
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        PropertyDescriptor descriptor = this.flowAnalysisRuleNode.getPropertyDescriptor(property.getName());
        if (descriptor == null) {
            return null;
        }
        String configuredValue = this.properties.get(property);
        StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)new StandardResourceReferenceFactory(), descriptor);
        return new StandardPropertyValue((ResourceContext)resourceContext, configuredValue == null ? descriptor.getDefaultValue() : configuredValue, (ControllerServiceLookup)this.serviceProvider, this.parameterLookup, this.preparedQueries.get(property));
    }
}

