/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.extensions;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.Response;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.extensions.ExtensionClient;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.stateless.config.SslConfigurationUtil;
import org.apache.nifi.stateless.config.SslContextDefinition;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusExtensionClient
implements ExtensionClient {
    private static final Logger logger = LoggerFactory.getLogger(NexusExtensionClient.class);
    private static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final String URL_CHARSET = "UTF-8";
    private final String baseUrl;
    private final long timeoutMillis;
    private final SslContextDefinition sslContextDefinition;

    public NexusExtensionClient(String baseUrl, SslContextDefinition sslContextDefinition, String timeout) {
        this.baseUrl = baseUrl;
        this.sslContextDefinition = sslContextDefinition;
        this.timeoutMillis = timeout == null ? DEFAULT_TIMEOUT_MILLIS : FormatUtils.getTimeDuration((String)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public InputStream getExtension(BundleCoordinate bundleCoordinate) throws IOException {
        String url = this.resolveUrl(bundleCoordinate);
        logger.debug("Attempting to fetch {} from {}", (Object)bundleCoordinate, (Object)url);
        OkHttpClient okHttpClient = this.createClient();
        Request request = new Request.Builder().get().url(url).build();
        Call call = okHttpClient.newCall(request);
        final Response response = call.execute();
        if (response.isSuccessful() && response.body() != null) {
            logger.debug("Successfully obtained stream for extension {} from {}", (Object)bundleCoordinate, (Object)url);
            InputStream extensionByteStream = response.body().byteStream();
            return new FilterInputStream(this, extensionByteStream){

                @Override
                public void close() throws IOException {
                    response.close();
                    super.close();
                }
            };
        }
        try {
            if (response.code() == Response.Status.NOT_FOUND.getStatusCode()) {
                logger.debug("Received NOT FOUND response for extension {} from {}", (Object)bundleCoordinate, (Object)url);
                InputStream extensionByteStream = null;
                return extensionByteStream;
            }
            String responseText = response.body() == null ? "<No Response Body>" : response.body().string();
            throw new IOException("Failed to fetch extension " + String.valueOf(bundleCoordinate) + " from " + url + ". Received repsonse of " + response.code() + ": " + responseText);
        }
        finally {
            response.close();
            okHttpClient.dispatcher().executorService().shutdown();
            okHttpClient.connectionPool().evictAll();
        }
    }

    private OkHttpClient createClient() {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().readTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS).connectTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS);
        if (this.sslContextDefinition != null) {
            TlsConfiguration tlsConfiguration = SslConfigurationUtil.createTlsConfiguration(this.sslContextDefinition);
            try {
                X509TrustManager trustManager = SslContextFactory.getX509TrustManager((TlsConfiguration)tlsConfiguration);
                SSLContext sslContext = SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration);
                okHttpClientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            }
            catch (TlsException e) {
                throw new IllegalArgumentException("TLS Configuration Failed: Check SSL Context Properties", e);
            }
        }
        return okHttpClientBuilder.build();
    }

    private String resolveUrl(BundleCoordinate bundleCoordinate) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(this.baseUrl);
        if (!this.baseUrl.endsWith("/")) {
            sb.append("/");
        }
        String artifactPath = URLEncoder.encode(bundleCoordinate.getId(), URL_CHARSET);
        String versionPath = URLEncoder.encode(bundleCoordinate.getVersion(), URL_CHARSET);
        sb.append(URLEncoder.encode(bundleCoordinate.getGroup(), URL_CHARSET).replace(".", "/"));
        sb.append("/");
        sb.append(artifactPath);
        sb.append("/");
        sb.append(versionPath);
        sb.append("/");
        sb.append(artifactPath).append("-").append(versionPath);
        sb.append(".nar");
        return sb.toString();
    }

    public String toString() {
        return "NexusExtensionClient[baseUrl=" + this.baseUrl + "]";
    }
}

