/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.Repetition;

public class UnionRecordField
implements RecordField {
    private final String fieldName;
    private final Repetition repetition;
    private final List<RecordField> possibilities;

    public UnionRecordField(String fieldName, Repetition repetition, RecordField ... possibilities) {
        this(fieldName, repetition, Arrays.asList(possibilities));
    }

    public UnionRecordField(String fieldName, Repetition repetition, List<RecordField> possibilities) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.repetition = Objects.requireNonNull(repetition);
        this.possibilities = Objects.requireNonNull(possibilities);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FieldType getFieldType() {
        return FieldType.UNION;
    }

    @Override
    public Repetition getRepetition() {
        return this.repetition;
    }

    @Override
    public List<RecordField> getSubFields() {
        return this.possibilities;
    }

    public String toString() {
        return "UnionRecordField[name=" + this.fieldName + ", possible types=" + String.valueOf(this.possibilities) + "]";
    }
}

