/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.MissingBundleException;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSerializer;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.serialization.VersionedFlowSerializer;
import org.apache.nifi.controller.serialization.VersionedFlowSynchronizer;
import org.apache.nifi.groups.BundleUpdateStrategy;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.persistence.FlowConfigurationArchiveManager;
import org.apache.nifi.persistence.FlowConfigurationDAO;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardFlowConfigurationDAO
implements FlowConfigurationDAO {
    private static final Logger LOG = LoggerFactory.getLogger(StandardFlowConfigurationDAO.class);
    private static final String CLUSTER_FLOW_SERIALIZATION_FORMAT = "nifi.cluster.flow.serialization.format";
    private static final String FLOW_SERIALIZATION_FORMAT_JSON = "JSON";
    private final File jsonFile;
    private final FlowConfigurationArchiveManager archiveManager;
    private final NiFiProperties nifiProperties;
    private final ExtensionManager extensionManager;
    private volatile boolean jsonFileExists;
    private final String clusterFlowSerializationFormat;

    public StandardFlowConfigurationDAO(NiFiProperties nifiProperties, ExtensionManager extensionManager) throws IOException {
        this.nifiProperties = nifiProperties;
        this.clusterFlowSerializationFormat = nifiProperties.getProperty(CLUSTER_FLOW_SERIALIZATION_FORMAT, FLOW_SERIALIZATION_FORMAT_JSON);
        this.jsonFile = nifiProperties.getFlowConfigurationFile();
        boolean bl = this.jsonFileExists = this.jsonFile.length() > 0L;
        if (!this.jsonFile.exists()) {
            if (!this.jsonFile.getParentFile().exists()) {
                Files.createDirectories(this.jsonFile.getParentFile().toPath(), new FileAttribute[0]);
            }
        } else if (!this.jsonFile.canRead() || !this.jsonFile.canWrite()) {
            throw new IOException(String.valueOf(this.jsonFile) + " exists but you have insufficient read/write privileges");
        }
        this.extensionManager = extensionManager;
        this.archiveManager = new FlowConfigurationArchiveManager(nifiProperties);
    }

    @Override
    public boolean isFlowPresent() {
        return this.getReadableFile() != null;
    }

    @Override
    public synchronized void load(FlowController controller, DataFlow dataFlow, FlowService flowService, BundleUpdateStrategy bundleUpdateStrategy) throws IOException, FlowSerializationException, FlowSynchronizationException, UninheritableFlowException, MissingBundleException {
        VersionedFlowSynchronizer standardFlowSynchronizer = new VersionedFlowSynchronizer(this.extensionManager, this.nifiProperties.getFlowConfigurationFile(), this.archiveManager);
        controller.synchronize(standardFlowSynchronizer, dataFlow, flowService, bundleUpdateStrategy);
        if (VersionedFlowSynchronizer.isFlowEmpty(dataFlow)) {
            this.save(controller, true);
        }
    }

    private File getReadableFile() {
        return this.jsonFileExists ? this.jsonFile : null;
    }

    @Override
    public synchronized void load(OutputStream os) throws IOException {
        File file = this.getReadableFile();
        if (file == null) {
            return;
        }
        try (FileInputStream inStream = new FileInputStream(file);
             GZIPInputStream gzipIn = new GZIPInputStream(inStream);){
            FileUtils.copy((InputStream)gzipIn, (OutputStream)os);
        }
    }

    @Override
    public void load(OutputStream os, boolean compressed) throws IOException {
        File file = this.getReadableFile();
        if (file == null) {
            return;
        }
        if (compressed) {
            Files.copy(file.toPath(), os);
        } else {
            this.load(os);
        }
    }

    @Override
    public void save(FlowController controller) throws IOException {
        LOG.trace("Saving flow to disk");
        this.save(controller, true);
        this.jsonFileExists = true;
        LOG.debug("Finished saving flow to disk");
    }

    @Override
    public synchronized void save(FlowController controller, OutputStream os) throws IOException {
        try {
            if (!FLOW_SERIALIZATION_FORMAT_JSON.equalsIgnoreCase(this.clusterFlowSerializationFormat)) {
                throw new IllegalArgumentException("Unknown serialization format");
            }
            VersionedFlowSerializer serializer = new VersionedFlowSerializer(this.extensionManager);
            controller.serialize(serializer, os);
        }
        catch (FlowSerializationException fse) {
            throw new IOException(fse);
        }
    }

    @Override
    public synchronized void save(FlowController controller, boolean archive) throws IOException {
        if (null == controller) {
            throw new NullPointerException();
        }
        this.saveJson(controller, archive);
    }

    private void saveJson(FlowController controller, boolean archive) throws IOException {
        VersionedFlowSerializer serializer = new VersionedFlowSerializer(controller.getExtensionManager());
        this.saveFlow(controller, serializer, this.jsonFile, archive);
        this.jsonFileExists = true;
    }

    private void saveFlow(FlowController controller, FlowSerializer<?> serializer, File file, boolean archive) throws IOException {
        block9: {
            File tempFile = new File(file.getParentFile(), file.getName() + ".temp.gz");
            try {
                this.serializeControllerStateToTempFile(controller, serializer, tempFile);
                Files.deleteIfExists(file.toPath());
                FileUtils.renameFile((File)tempFile, (File)file, (int)5, (boolean)true);
            }
            catch (FlowSerializationException fse) {
                throw new IOException(fse);
            }
            finally {
                Files.deleteIfExists(tempFile.toPath());
            }
            if (archive) {
                try {
                    this.archiveManager.archive(file);
                }
                catch (Exception ex) {
                    LOG.error("Unable to archive flow configuration as requested due to " + String.valueOf(ex));
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.error("", (Throwable)ex);
                }
            }
        }
    }

    private void serializeControllerStateToTempFile(FlowController controller, FlowSerializer<?> serializer, File tempFile) throws IOException {
        try (FileOutputStream fileOut = new FileOutputStream(tempFile);
             GZIPOutputStream outStream = new GZIPOutputStream(fileOut);){
            controller.serialize(serializer, outStream);
        }
    }
}

