/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;

public class MemoryPoolPeakUsageTask
implements DiagnosticTask {
    public DiagnosticsDumpElement captureDump(boolean verbose) {
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<CallSite> details = new ArrayList<CallSite>();
        for (MemoryPoolMXBean poolBean : pools) {
            String maxUsageDescription;
            String poolName = poolBean.getName();
            MemoryUsage usage = poolBean.getPeakUsage();
            long maxUsed = usage.getUsed();
            long maxAvailable = usage.getMax();
            if (maxAvailable > 0L) {
                double percentage = (double)maxUsed * 100.0 / (double)maxAvailable;
                maxUsageDescription = String.format("%1$,d bytes, %2$.2f%%", maxUsed, percentage);
            } else {
                maxUsageDescription = String.format("%1$,d bytes", maxUsed);
            }
            details.add((CallSite)((Object)(poolName + ": " + maxUsageDescription)));
        }
        return new StandardDiagnosticsDumpElement("Memory Pool Peak Usage", details);
    }
}

