/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.GarbageCollectionEvent;
import org.apache.nifi.controller.GarbageCollectionLog;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;

public class GarbageCollectionDiagnosticTask
implements DiagnosticTask {
    private final FlowController flowController;

    public GarbageCollectionDiagnosticTask(FlowController flowController) {
        this.flowController = flowController;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        ArrayList<Object> details = new ArrayList<Object>();
        for (GarbageCollectorMXBean garbageCollector : garbageCollectors) {
            details.add(garbageCollector.getName() + " Collection Count : " + garbageCollector.getCollectionCount());
            details.add(garbageCollector.getName() + " Collection Time (ms) : " + garbageCollector.getCollectionTime());
        }
        GarbageCollectionLog gcLog = this.flowController.getGarbageCollectionLog();
        List<GarbageCollectionEvent> events = gcLog.getGarbageCollectionEvents();
        details.add("");
        details.add("Longest Garbage Collection Event: " + String.valueOf(gcLog.getLongestGarbageCollectionEvent()));
        details.add("Number of Garbage Collection Events Per Action: " + String.valueOf(gcLog.getGarbageCollectionCounts()));
        details.add("Average Duration of Garbage Collection Event Per Action: " + String.valueOf(gcLog.getAverageGarbageCollectionDurations()));
        details.add("");
        details.add("Last " + events.size() + " Garbage Collection Events that had a duration exceeding " + gcLog.getMinDurationThreshold() + " millis:");
        Collections.reverse(events);
        for (GarbageCollectionEvent event : events) {
            details.add(event.toString());
        }
        return new StandardDiagnosticsDumpElement("Garbage Collection", details);
    }
}

