/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.storage.questdb;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.SqlExecutionContext;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.history.ComponentDetailsStorage;
import org.apache.nifi.controller.status.history.CounterMetricDescriptor;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.ProcessorStatusDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusHistory;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.questdb.QuestDbContext;
import org.apache.nifi.controller.status.history.questdb.QuestDbEntityReadingTemplate;
import org.apache.nifi.controller.status.history.questdb.QuestDbEntityWritingTemplate;
import org.apache.nifi.controller.status.history.questdb.QuestDbReadingTemplate;
import org.apache.nifi.controller.status.history.questdb.QuestDbStatusSnapshotMapper;
import org.apache.nifi.controller.status.history.questdb.QuestDbWritingTemplate;
import org.apache.nifi.controller.status.history.storage.ProcessorStatusStorage;
import org.apache.nifi.controller.status.history.storage.questdb.ComponentCounterWritingTemplate;

public class QuestDbProcessorStatusStorage
implements ProcessorStatusStorage {
    private static final String TABLE_NAME = "processorStatus";
    private static final Map<Integer, MetricDescriptor<ProcessorStatus>> METRICS = new HashMap<Integer, MetricDescriptor<ProcessorStatus>>();
    private final QuestDbEntityWritingTemplate<ProcessorStatus> writingTemplate = new QuestDbEntityWritingTemplate<ProcessorStatus>("processorStatus", (statusEntry, row) -> {
        row.putSym(1, (CharSequence)statusEntry.getId());
        METRICS.keySet().forEach(ordinal -> row.putLong(ordinal.intValue(), METRICS.get(ordinal).getValueFunction().getValue(statusEntry).longValue()));
    });
    private static final QuestDbWritingTemplate<Pair<Instant, ProcessorStatus>> counterWritingTemplate;
    private final Function<Record, StandardStatusSnapshot> statusSnapshotMapper = new QuestDbStatusSnapshotMapper(METRICS);
    private final QuestDbEntityReadingTemplate<StandardStatusSnapshot, List<StandardStatusSnapshot>> readingTemplate = new QuestDbEntityReadingTemplate<StandardStatusSnapshot, List>("SELECT * FROM %s WHERE componentId = '%s' AND capturedAt > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND capturedAt < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY capturedAt ASC", this.statusSnapshotMapper, e -> e, e -> Collections.emptyList());
    private final QuestDbContext dbContext;
    private final ComponentDetailsStorage componentDetailsStorage;

    public QuestDbProcessorStatusStorage(QuestDbContext dbContext, ComponentDetailsStorage componentDetailsStorage) {
        this.dbContext = dbContext;
        this.componentDetailsStorage = componentDetailsStorage;
    }

    @Override
    public StatusHistory read(String componentId, Instant start, Instant end, int preferredDataPoints) {
        List snapshots = (List)this.readingTemplate.read(this.dbContext.getEngine(), this.dbContext.getSqlExecutionContext(), Arrays.asList(TABLE_NAME, componentId, DATE_FORMATTER.format(start), DATE_FORMATTER.format(end)));
        return new StandardStatusHistory(new ArrayList<StatusSnapshot>(snapshots.subList(Math.max(snapshots.size() - preferredDataPoints, 0), snapshots.size())), this.componentDetailsStorage.getDetails(componentId), new Date());
    }

    @Override
    public StatusHistory readWithCounter(String componentId, Instant start, Instant end, int preferredDataPoints) {
        SqlExecutionContext executionContext = this.dbContext.getSqlExecutionContext();
        List snapshots = (List)this.readingTemplate.read(this.dbContext.getEngine(), executionContext, Arrays.asList(TABLE_NAME, componentId, DATE_FORMATTER.format(start), DATE_FORMATTER.format(end)));
        CounterReadingTemplate counterReadingTemplate = new CounterReadingTemplate(this, snapshots);
        ArrayList enrichedSnapshots = new ArrayList((Collection)counterReadingTemplate.read(this.dbContext.getEngine(), executionContext, Arrays.asList("componentCounter", componentId, DATE_FORMATTER.format(start), DATE_FORMATTER.format(end))));
        return new StandardStatusHistory(enrichedSnapshots.subList(Math.max(snapshots.size() - preferredDataPoints, 0), snapshots.size()), this.componentDetailsStorage.getDetails(componentId), new Date());
    }

    @Override
    public void store(List<Pair<Instant, ProcessorStatus>> statusEntries) {
        SqlExecutionContext executionContext = this.dbContext.getSqlExecutionContext();
        this.writingTemplate.insert(this.dbContext.getEngine(), executionContext, statusEntries);
        counterWritingTemplate.insert(this.dbContext.getEngine(), executionContext, statusEntries);
    }

    static {
        METRICS.put(2, ProcessorStatusDescriptor.BYTES_READ.getDescriptor());
        METRICS.put(3, ProcessorStatusDescriptor.BYTES_WRITTEN.getDescriptor());
        METRICS.put(4, ProcessorStatusDescriptor.BYTES_TRANSFERRED.getDescriptor());
        METRICS.put(5, ProcessorStatusDescriptor.INPUT_BYTES.getDescriptor());
        METRICS.put(6, ProcessorStatusDescriptor.INPUT_COUNT.getDescriptor());
        METRICS.put(7, ProcessorStatusDescriptor.OUTPUT_BYTES.getDescriptor());
        METRICS.put(8, ProcessorStatusDescriptor.OUTPUT_COUNT.getDescriptor());
        METRICS.put(9, ProcessorStatusDescriptor.TASK_COUNT.getDescriptor());
        METRICS.put(10, ProcessorStatusDescriptor.TASK_MILLIS.getDescriptor());
        METRICS.put(11, ProcessorStatusDescriptor.TASK_NANOS.getDescriptor());
        METRICS.put(12, ProcessorStatusDescriptor.FLOWFILES_REMOVED.getDescriptor());
        METRICS.put(13, ProcessorStatusDescriptor.AVERAGE_LINEAGE_DURATION.getDescriptor());
        METRICS.put(14, ProcessorStatusDescriptor.AVERAGE_TASK_NANOS.getDescriptor());
        counterWritingTemplate = new ComponentCounterWritingTemplate();
    }

    private final class CounterReadingTemplate
    extends QuestDbReadingTemplate<List<StandardStatusSnapshot>> {
        private final List<StandardStatusSnapshot> processorStatusSnapshots;

        public CounterReadingTemplate(QuestDbProcessorStatusStorage questDbProcessorStatusStorage, List<StandardStatusSnapshot> processorStatusSnapshots) {
            super("SELECT * FROM %s WHERE componentId = '%s' AND capturedAt > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND capturedAt < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY capturedAt ASC", (Exception e) -> Collections.emptyList());
            this.processorStatusSnapshots = processorStatusSnapshots;
        }

        @Override
        protected List<StandardStatusSnapshot> processResult(RecordCursor cursor) {
            Map<Long, StandardStatusSnapshot> snapshotsByTime = this.processorStatusSnapshots.stream().collect(Collectors.toMap(s -> s.getTimestamp().getTime(), s -> s));
            while (cursor.hasNext()) {
                Record record = cursor.getRecord();
                long recordCreatedAt = TimeUnit.MICROSECONDS.toMillis(record.getTimestamp(0));
                StandardStatusSnapshot snapshot = snapshotsByTime.get(recordCreatedAt);
                String counterName = new StringBuilder(record.getSym(2)).toString();
                long counterValue = record.getLong(3);
                CounterMetricDescriptor metricDescriptor = new CounterMetricDescriptor(counterName, counterName + " (5 mins)", counterName + " (5 mins)", MetricDescriptor.Formatter.COUNT, s -> s.getCounters() == null ? null : (Long)s.getCounters().get(counterName));
                snapshot.addStatusMetric(metricDescriptor, counterValue);
            }
            return this.processorStatusSnapshots;
        }
    }
}

