/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.encrypt.EncryptionException;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.VersionedConfigurableExtension;
import org.apache.nifi.flow.VersionedPropertyDescriptor;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowSynchronizationUtils {
    private static final Logger logger = LoggerFactory.getLogger(FlowSynchronizationUtils.class);

    private FlowSynchronizationUtils() {
    }

    static BundleCoordinate createBundleCoordinate(ExtensionManager extensionManager, Bundle bundle, String componentType) {
        BundleCoordinate coordinate;
        try {
            BundleDTO bundleDto = new BundleDTO(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
            coordinate = BundleUtils.getCompatibleBundle((ExtensionManager)extensionManager, (String)componentType, (BundleDTO)bundleDto);
        }
        catch (IllegalStateException e) {
            coordinate = new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
        }
        return coordinate;
    }

    static Set<String> getSensitiveDynamicPropertyNames(ComponentNode componentNode, VersionedConfigurableExtension extension) {
        LinkedHashSet versionedSensitivePropertyNames = new LinkedHashSet();
        extension.getProperties().entrySet().stream().filter(entry -> FlowSynchronizationUtils.isValueSensitive((String)entry.getValue())).map(Map.Entry::getKey).forEach(versionedSensitivePropertyNames::add);
        extension.getPropertyDescriptors().values().stream().filter(VersionedPropertyDescriptor::isSensitive).map(VersionedPropertyDescriptor::getName).forEach(versionedSensitivePropertyNames::add);
        return versionedSensitivePropertyNames.stream().map(arg_0 -> ((ComponentNode)componentNode).getPropertyDescriptor(arg_0)).filter(PropertyDescriptor::isDynamic).map(PropertyDescriptor::getName).collect(Collectors.toSet());
    }

    static boolean isValueSensitive(String value) {
        return value != null && value.startsWith("enc{") && value.endsWith("}");
    }

    static Map<String, String> decryptProperties(Map<String, String> encrypted, PropertyEncryptor encryptor) {
        HashMap<String, String> decrypted = new HashMap<String, String>(encrypted.size());
        encrypted.forEach((key, value) -> decrypted.put((String)key, FlowSynchronizationUtils.decrypt(value, encryptor)));
        return decrypted;
    }

    static String decrypt(String value, PropertyEncryptor encryptor) {
        if (FlowSynchronizationUtils.isValueSensitive(value)) {
            try {
                return encryptor.decrypt(value.substring("enc{".length(), value.length() - "}".length()));
            }
            catch (EncryptionException e) {
                String moreDescriptiveMessage = "There was a problem decrypting a sensitive flow configuration value. Check that the nifi.sensitive.props.key value in nifi.properties matches the value used to encrypt the flow.json.gz file";
                logger.error("There was a problem decrypting a sensitive flow configuration value. Check that the nifi.sensitive.props.key value in nifi.properties matches the value used to encrypt the flow.json.gz file", (Throwable)e);
                throw new EncryptionException("There was a problem decrypting a sensitive flow configuration value. Check that the nifi.sensitive.props.key value in nifi.properties matches the value used to encrypt the flow.json.gz file", (Throwable)e);
            }
        }
        return value;
    }
}

